/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.CopyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CopyDBParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBParameterGroupRequest>, CopyDBParameterGroupRequest> {
    public Request<CopyDBParameterGroupRequest> marshall(CopyDBParameterGroupRequest copyDBParameterGroupRequest) {
        if (copyDBParameterGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBParameterGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CopyDBParameterGroup");
        request.addParameter("Version", "2014-09-01");
        if (copyDBParameterGroupRequest.getSourceDBParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBParameterGroupIdentifier", StringUtils.fromString((String)copyDBParameterGroupRequest.getSourceDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.getTargetDBParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBParameterGroupIdentifier", StringUtils.fromString((String)copyDBParameterGroupRequest.getTargetDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.getTargetDBParameterGroupDescription() != null) {
            request.addParameter("TargetDBParameterGroupDescription", StringUtils.fromString((String)copyDBParameterGroupRequest.getTargetDBParameterGroupDescription()));
        }
        List<Tag> tagsList = copyDBParameterGroupRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

