/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Slot;
import com.amazonaws.services.quicksight.model.transform.TopicTemplateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private String templateType;
    private List<Slot> slots;

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public TopicTemplate withTemplateType(String templateType) {
        this.setTemplateType(templateType);
        return this;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public void setSlots(Collection<Slot> slots) {
        if (slots == null) {
            this.slots = null;
            return;
        }
        this.slots = new ArrayList<Slot>(slots);
    }

    public TopicTemplate withSlots(Slot ... slots) {
        if (this.slots == null) {
            this.setSlots(new ArrayList<Slot>(slots.length));
        }
        for (Slot ele : slots) {
            this.slots.add(ele);
        }
        return this;
    }

    public TopicTemplate withSlots(Collection<Slot> slots) {
        this.setSlots(slots);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTemplateType() != null) {
            sb.append("TemplateType: ").append(this.getTemplateType()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append(this.getSlots());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicTemplate)) {
            return false;
        }
        TopicTemplate other = (TopicTemplate)obj;
        if (other.getTemplateType() == null ^ this.getTemplateType() == null) {
            return false;
        }
        if (other.getTemplateType() != null && !other.getTemplateType().equals(this.getTemplateType())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        return other.getSlots() == null || other.getSlots().equals(this.getSlots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTemplateType() == null ? 0 : this.getTemplateType().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        return hashCode;
    }

    public TopicTemplate clone() {
        try {
            return (TopicTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

