/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.private5g;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.private5g.AWSPrivate5GAsync;
import com.amazonaws.services.private5g.AWSPrivate5GAsyncClientBuilder;
import com.amazonaws.services.private5g.AWSPrivate5GClient;
import com.amazonaws.services.private5g.model.AcknowledgeOrderReceiptRequest;
import com.amazonaws.services.private5g.model.AcknowledgeOrderReceiptResult;
import com.amazonaws.services.private5g.model.ActivateDeviceIdentifierRequest;
import com.amazonaws.services.private5g.model.ActivateDeviceIdentifierResult;
import com.amazonaws.services.private5g.model.ActivateNetworkSiteRequest;
import com.amazonaws.services.private5g.model.ActivateNetworkSiteResult;
import com.amazonaws.services.private5g.model.ConfigureAccessPointRequest;
import com.amazonaws.services.private5g.model.ConfigureAccessPointResult;
import com.amazonaws.services.private5g.model.CreateNetworkRequest;
import com.amazonaws.services.private5g.model.CreateNetworkResult;
import com.amazonaws.services.private5g.model.CreateNetworkSiteRequest;
import com.amazonaws.services.private5g.model.CreateNetworkSiteResult;
import com.amazonaws.services.private5g.model.DeactivateDeviceIdentifierRequest;
import com.amazonaws.services.private5g.model.DeactivateDeviceIdentifierResult;
import com.amazonaws.services.private5g.model.DeleteNetworkRequest;
import com.amazonaws.services.private5g.model.DeleteNetworkResult;
import com.amazonaws.services.private5g.model.DeleteNetworkSiteRequest;
import com.amazonaws.services.private5g.model.DeleteNetworkSiteResult;
import com.amazonaws.services.private5g.model.GetDeviceIdentifierRequest;
import com.amazonaws.services.private5g.model.GetDeviceIdentifierResult;
import com.amazonaws.services.private5g.model.GetNetworkRequest;
import com.amazonaws.services.private5g.model.GetNetworkResourceRequest;
import com.amazonaws.services.private5g.model.GetNetworkResourceResult;
import com.amazonaws.services.private5g.model.GetNetworkResult;
import com.amazonaws.services.private5g.model.GetNetworkSiteRequest;
import com.amazonaws.services.private5g.model.GetNetworkSiteResult;
import com.amazonaws.services.private5g.model.GetOrderRequest;
import com.amazonaws.services.private5g.model.GetOrderResult;
import com.amazonaws.services.private5g.model.ListDeviceIdentifiersRequest;
import com.amazonaws.services.private5g.model.ListDeviceIdentifiersResult;
import com.amazonaws.services.private5g.model.ListNetworkResourcesRequest;
import com.amazonaws.services.private5g.model.ListNetworkResourcesResult;
import com.amazonaws.services.private5g.model.ListNetworkSitesRequest;
import com.amazonaws.services.private5g.model.ListNetworkSitesResult;
import com.amazonaws.services.private5g.model.ListNetworksRequest;
import com.amazonaws.services.private5g.model.ListNetworksResult;
import com.amazonaws.services.private5g.model.ListOrdersRequest;
import com.amazonaws.services.private5g.model.ListOrdersResult;
import com.amazonaws.services.private5g.model.ListTagsForResourceRequest;
import com.amazonaws.services.private5g.model.ListTagsForResourceResult;
import com.amazonaws.services.private5g.model.PingRequest;
import com.amazonaws.services.private5g.model.PingResult;
import com.amazonaws.services.private5g.model.StartNetworkResourceUpdateRequest;
import com.amazonaws.services.private5g.model.StartNetworkResourceUpdateResult;
import com.amazonaws.services.private5g.model.TagResourceRequest;
import com.amazonaws.services.private5g.model.TagResourceResult;
import com.amazonaws.services.private5g.model.UntagResourceRequest;
import com.amazonaws.services.private5g.model.UntagResourceResult;
import com.amazonaws.services.private5g.model.UpdateNetworkSitePlanRequest;
import com.amazonaws.services.private5g.model.UpdateNetworkSitePlanResult;
import com.amazonaws.services.private5g.model.UpdateNetworkSiteRequest;
import com.amazonaws.services.private5g.model.UpdateNetworkSiteResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPrivate5GAsyncClient
extends AWSPrivate5GClient
implements AWSPrivate5GAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPrivate5GAsyncClientBuilder asyncBuilder() {
        return AWSPrivate5GAsyncClientBuilder.standard();
    }

    AWSPrivate5GAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPrivate5GAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcknowledgeOrderReceiptResult> acknowledgeOrderReceiptAsync(AcknowledgeOrderReceiptRequest request) {
        return this.acknowledgeOrderReceiptAsync(request, null);
    }

    @Override
    public Future<AcknowledgeOrderReceiptResult> acknowledgeOrderReceiptAsync(AcknowledgeOrderReceiptRequest request, final AsyncHandler<AcknowledgeOrderReceiptRequest, AcknowledgeOrderReceiptResult> asyncHandler) {
        final AcknowledgeOrderReceiptRequest finalRequest = (AcknowledgeOrderReceiptRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcknowledgeOrderReceiptResult>(){

            @Override
            public AcknowledgeOrderReceiptResult call() throws Exception {
                AcknowledgeOrderReceiptResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeAcknowledgeOrderReceipt(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivateDeviceIdentifierResult> activateDeviceIdentifierAsync(ActivateDeviceIdentifierRequest request) {
        return this.activateDeviceIdentifierAsync(request, null);
    }

    @Override
    public Future<ActivateDeviceIdentifierResult> activateDeviceIdentifierAsync(ActivateDeviceIdentifierRequest request, final AsyncHandler<ActivateDeviceIdentifierRequest, ActivateDeviceIdentifierResult> asyncHandler) {
        final ActivateDeviceIdentifierRequest finalRequest = (ActivateDeviceIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivateDeviceIdentifierResult>(){

            @Override
            public ActivateDeviceIdentifierResult call() throws Exception {
                ActivateDeviceIdentifierResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeActivateDeviceIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivateNetworkSiteResult> activateNetworkSiteAsync(ActivateNetworkSiteRequest request) {
        return this.activateNetworkSiteAsync(request, null);
    }

    @Override
    public Future<ActivateNetworkSiteResult> activateNetworkSiteAsync(ActivateNetworkSiteRequest request, final AsyncHandler<ActivateNetworkSiteRequest, ActivateNetworkSiteResult> asyncHandler) {
        final ActivateNetworkSiteRequest finalRequest = (ActivateNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivateNetworkSiteResult>(){

            @Override
            public ActivateNetworkSiteResult call() throws Exception {
                ActivateNetworkSiteResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeActivateNetworkSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfigureAccessPointResult> configureAccessPointAsync(ConfigureAccessPointRequest request) {
        return this.configureAccessPointAsync(request, null);
    }

    @Override
    public Future<ConfigureAccessPointResult> configureAccessPointAsync(ConfigureAccessPointRequest request, final AsyncHandler<ConfigureAccessPointRequest, ConfigureAccessPointResult> asyncHandler) {
        final ConfigureAccessPointRequest finalRequest = (ConfigureAccessPointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ConfigureAccessPointResult>(){

            @Override
            public ConfigureAccessPointResult call() throws Exception {
                ConfigureAccessPointResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeConfigureAccessPoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNetworkResult> createNetworkAsync(CreateNetworkRequest request) {
        return this.createNetworkAsync(request, null);
    }

    @Override
    public Future<CreateNetworkResult> createNetworkAsync(CreateNetworkRequest request, final AsyncHandler<CreateNetworkRequest, CreateNetworkResult> asyncHandler) {
        final CreateNetworkRequest finalRequest = (CreateNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNetworkResult>(){

            @Override
            public CreateNetworkResult call() throws Exception {
                CreateNetworkResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeCreateNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNetworkSiteResult> createNetworkSiteAsync(CreateNetworkSiteRequest request) {
        return this.createNetworkSiteAsync(request, null);
    }

    @Override
    public Future<CreateNetworkSiteResult> createNetworkSiteAsync(CreateNetworkSiteRequest request, final AsyncHandler<CreateNetworkSiteRequest, CreateNetworkSiteResult> asyncHandler) {
        final CreateNetworkSiteRequest finalRequest = (CreateNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNetworkSiteResult>(){

            @Override
            public CreateNetworkSiteResult call() throws Exception {
                CreateNetworkSiteResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeCreateNetworkSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeactivateDeviceIdentifierResult> deactivateDeviceIdentifierAsync(DeactivateDeviceIdentifierRequest request) {
        return this.deactivateDeviceIdentifierAsync(request, null);
    }

    @Override
    public Future<DeactivateDeviceIdentifierResult> deactivateDeviceIdentifierAsync(DeactivateDeviceIdentifierRequest request, final AsyncHandler<DeactivateDeviceIdentifierRequest, DeactivateDeviceIdentifierResult> asyncHandler) {
        final DeactivateDeviceIdentifierRequest finalRequest = (DeactivateDeviceIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeactivateDeviceIdentifierResult>(){

            @Override
            public DeactivateDeviceIdentifierResult call() throws Exception {
                DeactivateDeviceIdentifierResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeDeactivateDeviceIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNetworkResult> deleteNetworkAsync(DeleteNetworkRequest request) {
        return this.deleteNetworkAsync(request, null);
    }

    @Override
    public Future<DeleteNetworkResult> deleteNetworkAsync(DeleteNetworkRequest request, final AsyncHandler<DeleteNetworkRequest, DeleteNetworkResult> asyncHandler) {
        final DeleteNetworkRequest finalRequest = (DeleteNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNetworkResult>(){

            @Override
            public DeleteNetworkResult call() throws Exception {
                DeleteNetworkResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeDeleteNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNetworkSiteResult> deleteNetworkSiteAsync(DeleteNetworkSiteRequest request) {
        return this.deleteNetworkSiteAsync(request, null);
    }

    @Override
    public Future<DeleteNetworkSiteResult> deleteNetworkSiteAsync(DeleteNetworkSiteRequest request, final AsyncHandler<DeleteNetworkSiteRequest, DeleteNetworkSiteResult> asyncHandler) {
        final DeleteNetworkSiteRequest finalRequest = (DeleteNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNetworkSiteResult>(){

            @Override
            public DeleteNetworkSiteResult call() throws Exception {
                DeleteNetworkSiteResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeDeleteNetworkSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeviceIdentifierResult> getDeviceIdentifierAsync(GetDeviceIdentifierRequest request) {
        return this.getDeviceIdentifierAsync(request, null);
    }

    @Override
    public Future<GetDeviceIdentifierResult> getDeviceIdentifierAsync(GetDeviceIdentifierRequest request, final AsyncHandler<GetDeviceIdentifierRequest, GetDeviceIdentifierResult> asyncHandler) {
        final GetDeviceIdentifierRequest finalRequest = (GetDeviceIdentifierRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDeviceIdentifierResult>(){

            @Override
            public GetDeviceIdentifierResult call() throws Exception {
                GetDeviceIdentifierResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeGetDeviceIdentifier(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkResult> getNetworkAsync(GetNetworkRequest request) {
        return this.getNetworkAsync(request, null);
    }

    @Override
    public Future<GetNetworkResult> getNetworkAsync(GetNetworkRequest request, final AsyncHandler<GetNetworkRequest, GetNetworkResult> asyncHandler) {
        final GetNetworkRequest finalRequest = (GetNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkResult>(){

            @Override
            public GetNetworkResult call() throws Exception {
                GetNetworkResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeGetNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkResourceResult> getNetworkResourceAsync(GetNetworkResourceRequest request) {
        return this.getNetworkResourceAsync(request, null);
    }

    @Override
    public Future<GetNetworkResourceResult> getNetworkResourceAsync(GetNetworkResourceRequest request, final AsyncHandler<GetNetworkResourceRequest, GetNetworkResourceResult> asyncHandler) {
        final GetNetworkResourceRequest finalRequest = (GetNetworkResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkResourceResult>(){

            @Override
            public GetNetworkResourceResult call() throws Exception {
                GetNetworkResourceResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeGetNetworkResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkSiteResult> getNetworkSiteAsync(GetNetworkSiteRequest request) {
        return this.getNetworkSiteAsync(request, null);
    }

    @Override
    public Future<GetNetworkSiteResult> getNetworkSiteAsync(GetNetworkSiteRequest request, final AsyncHandler<GetNetworkSiteRequest, GetNetworkSiteResult> asyncHandler) {
        final GetNetworkSiteRequest finalRequest = (GetNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkSiteResult>(){

            @Override
            public GetNetworkSiteResult call() throws Exception {
                GetNetworkSiteResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeGetNetworkSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOrderResult> getOrderAsync(GetOrderRequest request) {
        return this.getOrderAsync(request, null);
    }

    @Override
    public Future<GetOrderResult> getOrderAsync(GetOrderRequest request, final AsyncHandler<GetOrderRequest, GetOrderResult> asyncHandler) {
        final GetOrderRequest finalRequest = (GetOrderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOrderResult>(){

            @Override
            public GetOrderResult call() throws Exception {
                GetOrderResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeGetOrder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeviceIdentifiersResult> listDeviceIdentifiersAsync(ListDeviceIdentifiersRequest request) {
        return this.listDeviceIdentifiersAsync(request, null);
    }

    @Override
    public Future<ListDeviceIdentifiersResult> listDeviceIdentifiersAsync(ListDeviceIdentifiersRequest request, final AsyncHandler<ListDeviceIdentifiersRequest, ListDeviceIdentifiersResult> asyncHandler) {
        final ListDeviceIdentifiersRequest finalRequest = (ListDeviceIdentifiersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeviceIdentifiersResult>(){

            @Override
            public ListDeviceIdentifiersResult call() throws Exception {
                ListDeviceIdentifiersResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeListDeviceIdentifiers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNetworkResourcesResult> listNetworkResourcesAsync(ListNetworkResourcesRequest request) {
        return this.listNetworkResourcesAsync(request, null);
    }

    @Override
    public Future<ListNetworkResourcesResult> listNetworkResourcesAsync(ListNetworkResourcesRequest request, final AsyncHandler<ListNetworkResourcesRequest, ListNetworkResourcesResult> asyncHandler) {
        final ListNetworkResourcesRequest finalRequest = (ListNetworkResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNetworkResourcesResult>(){

            @Override
            public ListNetworkResourcesResult call() throws Exception {
                ListNetworkResourcesResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeListNetworkResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNetworkSitesResult> listNetworkSitesAsync(ListNetworkSitesRequest request) {
        return this.listNetworkSitesAsync(request, null);
    }

    @Override
    public Future<ListNetworkSitesResult> listNetworkSitesAsync(ListNetworkSitesRequest request, final AsyncHandler<ListNetworkSitesRequest, ListNetworkSitesResult> asyncHandler) {
        final ListNetworkSitesRequest finalRequest = (ListNetworkSitesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNetworkSitesResult>(){

            @Override
            public ListNetworkSitesResult call() throws Exception {
                ListNetworkSitesResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeListNetworkSites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNetworksResult> listNetworksAsync(ListNetworksRequest request) {
        return this.listNetworksAsync(request, null);
    }

    @Override
    public Future<ListNetworksResult> listNetworksAsync(ListNetworksRequest request, final AsyncHandler<ListNetworksRequest, ListNetworksResult> asyncHandler) {
        final ListNetworksRequest finalRequest = (ListNetworksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNetworksResult>(){

            @Override
            public ListNetworksResult call() throws Exception {
                ListNetworksResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeListNetworks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOrdersResult> listOrdersAsync(ListOrdersRequest request) {
        return this.listOrdersAsync(request, null);
    }

    @Override
    public Future<ListOrdersResult> listOrdersAsync(ListOrdersRequest request, final AsyncHandler<ListOrdersRequest, ListOrdersResult> asyncHandler) {
        final ListOrdersRequest finalRequest = (ListOrdersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOrdersResult>(){

            @Override
            public ListOrdersResult call() throws Exception {
                ListOrdersResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeListOrders(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PingResult> pingAsync(PingRequest request) {
        return this.pingAsync(request, null);
    }

    @Override
    public Future<PingResult> pingAsync(PingRequest request, final AsyncHandler<PingRequest, PingResult> asyncHandler) {
        final PingRequest finalRequest = (PingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PingResult>(){

            @Override
            public PingResult call() throws Exception {
                PingResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executePing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartNetworkResourceUpdateResult> startNetworkResourceUpdateAsync(StartNetworkResourceUpdateRequest request) {
        return this.startNetworkResourceUpdateAsync(request, null);
    }

    @Override
    public Future<StartNetworkResourceUpdateResult> startNetworkResourceUpdateAsync(StartNetworkResourceUpdateRequest request, final AsyncHandler<StartNetworkResourceUpdateRequest, StartNetworkResourceUpdateResult> asyncHandler) {
        final StartNetworkResourceUpdateRequest finalRequest = (StartNetworkResourceUpdateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartNetworkResourceUpdateResult>(){

            @Override
            public StartNetworkResourceUpdateResult call() throws Exception {
                StartNetworkResourceUpdateResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeStartNetworkResourceUpdate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNetworkSiteResult> updateNetworkSiteAsync(UpdateNetworkSiteRequest request) {
        return this.updateNetworkSiteAsync(request, null);
    }

    @Override
    public Future<UpdateNetworkSiteResult> updateNetworkSiteAsync(UpdateNetworkSiteRequest request, final AsyncHandler<UpdateNetworkSiteRequest, UpdateNetworkSiteResult> asyncHandler) {
        final UpdateNetworkSiteRequest finalRequest = (UpdateNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNetworkSiteResult>(){

            @Override
            public UpdateNetworkSiteResult call() throws Exception {
                UpdateNetworkSiteResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeUpdateNetworkSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNetworkSitePlanResult> updateNetworkSitePlanAsync(UpdateNetworkSitePlanRequest request) {
        return this.updateNetworkSitePlanAsync(request, null);
    }

    @Override
    public Future<UpdateNetworkSitePlanResult> updateNetworkSitePlanAsync(UpdateNetworkSitePlanRequest request, final AsyncHandler<UpdateNetworkSitePlanRequest, UpdateNetworkSitePlanResult> asyncHandler) {
        final UpdateNetworkSitePlanRequest finalRequest = (UpdateNetworkSitePlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNetworkSitePlanResult>(){

            @Override
            public UpdateNetworkSitePlanResult call() throws Exception {
                UpdateNetworkSitePlanResult result = null;
                try {
                    result = AWSPrivate5GAsyncClient.this.executeUpdateNetworkSitePlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

