/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.EndpointUserMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointUser
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, List<String>> userAttributes;
    private String userId;

    public Map<String, List<String>> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Map<String, List<String>> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public EndpointUser withUserAttributes(Map<String, List<String>> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public EndpointUser addUserAttributesEntry(String key, List<String> value) {
        if (null == this.userAttributes) {
            this.userAttributes = new HashMap<String, List<String>>();
        }
        if (this.userAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userAttributes.put(key, value);
        return this;
    }

    public EndpointUser clearUserAttributesEntries() {
        this.userAttributes = null;
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public EndpointUser withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: ").append(this.getUserAttributes()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointUser)) {
            return false;
        }
        EndpointUser other = (EndpointUser)obj;
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        return other.getUserId() == null || other.getUserId().equals(this.getUserId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return hashCode;
    }

    public EndpointUser clone() {
        try {
            return (EndpointUser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointUserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

