/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.panorama.model.S3Location;

@SdkInternalApi
public class S3LocationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<String> OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectKey").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final S3LocationMarshaller instance = new S3LocationMarshaller();

    public static S3LocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Location s3Location, ProtocolMarshaller protocolMarshaller) {
        if (s3Location == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Location.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Location.getObjectKey(), OBJECTKEY_BINDING);
            protocolMarshaller.marshall((Object)s3Location.getRegion(), REGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

