/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medicalimaging;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.medicalimaging.AWSMedicalImaging;
import com.amazonaws.services.medicalimaging.AWSMedicalImagingClientBuilder;
import com.amazonaws.services.medicalimaging.model.AWSMedicalImagingException;
import com.amazonaws.services.medicalimaging.model.CopyImageSetRequest;
import com.amazonaws.services.medicalimaging.model.CopyImageSetResult;
import com.amazonaws.services.medicalimaging.model.CreateDatastoreRequest;
import com.amazonaws.services.medicalimaging.model.CreateDatastoreResult;
import com.amazonaws.services.medicalimaging.model.DeleteDatastoreRequest;
import com.amazonaws.services.medicalimaging.model.DeleteDatastoreResult;
import com.amazonaws.services.medicalimaging.model.DeleteImageSetRequest;
import com.amazonaws.services.medicalimaging.model.DeleteImageSetResult;
import com.amazonaws.services.medicalimaging.model.GetDICOMImportJobRequest;
import com.amazonaws.services.medicalimaging.model.GetDICOMImportJobResult;
import com.amazonaws.services.medicalimaging.model.GetDatastoreRequest;
import com.amazonaws.services.medicalimaging.model.GetDatastoreResult;
import com.amazonaws.services.medicalimaging.model.GetImageFrameRequest;
import com.amazonaws.services.medicalimaging.model.GetImageFrameResult;
import com.amazonaws.services.medicalimaging.model.GetImageSetMetadataRequest;
import com.amazonaws.services.medicalimaging.model.GetImageSetMetadataResult;
import com.amazonaws.services.medicalimaging.model.GetImageSetRequest;
import com.amazonaws.services.medicalimaging.model.GetImageSetResult;
import com.amazonaws.services.medicalimaging.model.ListDICOMImportJobsRequest;
import com.amazonaws.services.medicalimaging.model.ListDICOMImportJobsResult;
import com.amazonaws.services.medicalimaging.model.ListDatastoresRequest;
import com.amazonaws.services.medicalimaging.model.ListDatastoresResult;
import com.amazonaws.services.medicalimaging.model.ListImageSetVersionsRequest;
import com.amazonaws.services.medicalimaging.model.ListImageSetVersionsResult;
import com.amazonaws.services.medicalimaging.model.ListTagsForResourceRequest;
import com.amazonaws.services.medicalimaging.model.ListTagsForResourceResult;
import com.amazonaws.services.medicalimaging.model.SearchImageSetsRequest;
import com.amazonaws.services.medicalimaging.model.SearchImageSetsResult;
import com.amazonaws.services.medicalimaging.model.StartDICOMImportJobRequest;
import com.amazonaws.services.medicalimaging.model.StartDICOMImportJobResult;
import com.amazonaws.services.medicalimaging.model.TagResourceRequest;
import com.amazonaws.services.medicalimaging.model.TagResourceResult;
import com.amazonaws.services.medicalimaging.model.UntagResourceRequest;
import com.amazonaws.services.medicalimaging.model.UntagResourceResult;
import com.amazonaws.services.medicalimaging.model.UpdateImageSetMetadataRequest;
import com.amazonaws.services.medicalimaging.model.UpdateImageSetMetadataResult;
import com.amazonaws.services.medicalimaging.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.CopyImageSetRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.CopyImageSetResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.CreateDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.CreateDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.DeleteDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.DeleteDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.DeleteImageSetRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.DeleteImageSetResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetDICOMImportJobRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetDICOMImportJobResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetImageFrameRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetImageFrameResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetImageSetMetadataRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetImageSetMetadataResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetImageSetRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.GetImageSetResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListDICOMImportJobsRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListDICOMImportJobsResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListDatastoresRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListDatastoresResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListImageSetVersionsRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListImageSetVersionsResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.SearchImageSetsRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.SearchImageSetsResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.StartDICOMImportJobRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.StartDICOMImportJobResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.UpdateImageSetMetadataRequestProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.transform.UpdateImageSetMetadataResultJsonUnmarshaller;
import com.amazonaws.services.medicalimaging.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMedicalImagingClient
extends AmazonWebServiceClient
implements AWSMedicalImaging {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMedicalImaging.class);
    private static final String DEFAULT_SIGNING_NAME = "medical-imaging";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMedicalImagingException.class));

    public static AWSMedicalImagingClientBuilder builder() {
        return AWSMedicalImagingClientBuilder.standard();
    }

    AWSMedicalImagingClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMedicalImagingClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("medical-imaging.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/medicalimaging/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/medicalimaging/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CopyImageSetResult copyImageSet(CopyImageSetRequest request) {
        request = (CopyImageSetRequest)this.beforeClientExecution(request);
        return this.executeCopyImageSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CopyImageSetResult executeCopyImageSet(CopyImageSetRequest copyImageSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(copyImageSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CopyImageSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CopyImageSetRequestProtocolMarshaller(protocolFactory).marshall((CopyImageSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)copyImageSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CopyImageSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CopyImageSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CopyImageSetResult copyImageSetResult = (CopyImageSetResult)response.getAwsResponse();
            return copyImageSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDatastoreResult createDatastore(CreateDatastoreRequest request) {
        request = (CreateDatastoreRequest)this.beforeClientExecution(request);
        return this.executeCreateDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatastoreResult executeCreateDatastore(CreateDatastoreRequest createDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatastoreRequestProtocolMarshaller(protocolFactory).marshall((CreateDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDatastore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatastoreResult createDatastoreResult = (CreateDatastoreResult)response.getAwsResponse();
            return createDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatastoreResult deleteDatastore(DeleteDatastoreRequest request) {
        request = (DeleteDatastoreRequest)this.beforeClientExecution(request);
        return this.executeDeleteDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatastoreResult executeDeleteDatastore(DeleteDatastoreRequest deleteDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatastoreRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDatastore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatastoreResult deleteDatastoreResult = (DeleteDatastoreResult)response.getAwsResponse();
            return deleteDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteImageSetResult deleteImageSet(DeleteImageSetRequest request) {
        request = (DeleteImageSetRequest)this.beforeClientExecution(request);
        return this.executeDeleteImageSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteImageSetResult executeDeleteImageSet(DeleteImageSetRequest deleteImageSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteImageSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteImageSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteImageSetRequestProtocolMarshaller(protocolFactory).marshall((DeleteImageSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteImageSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteImageSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteImageSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteImageSetResult deleteImageSetResult = (DeleteImageSetResult)response.getAwsResponse();
            return deleteImageSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDICOMImportJobResult getDICOMImportJob(GetDICOMImportJobRequest request) {
        request = (GetDICOMImportJobRequest)this.beforeClientExecution(request);
        return this.executeGetDICOMImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDICOMImportJobResult executeGetDICOMImportJob(GetDICOMImportJobRequest getDICOMImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDICOMImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDICOMImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDICOMImportJobRequestProtocolMarshaller(protocolFactory).marshall((GetDICOMImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDICOMImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDICOMImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDICOMImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDICOMImportJobResult getDICOMImportJobResult = (GetDICOMImportJobResult)response.getAwsResponse();
            return getDICOMImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDatastoreResult getDatastore(GetDatastoreRequest request) {
        request = (GetDatastoreRequest)this.beforeClientExecution(request);
        return this.executeGetDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDatastoreResult executeGetDatastore(GetDatastoreRequest getDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDatastoreRequestProtocolMarshaller(protocolFactory).marshall((GetDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDatastore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDatastoreResult getDatastoreResult = (GetDatastoreResult)response.getAwsResponse();
            return getDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetImageFrameResult getImageFrame(GetImageFrameRequest request) {
        request = (GetImageFrameRequest)this.beforeClientExecution(request);
        return this.executeGetImageFrame(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetImageFrameResult executeGetImageFrame(GetImageFrameRequest getImageFrameRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getImageFrameRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetImageFrameRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetImageFrameRequestProtocolMarshaller(protocolFactory).marshall((GetImageFrameRequest)super.beforeMarshalling((AmazonWebServiceRequest)getImageFrameRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetImageFrame");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetImageFrameResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            GetImageFrameResult getImageFrameResult = (GetImageFrameResult)response.getAwsResponse();
            return getImageFrameResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetImageSetResult getImageSet(GetImageSetRequest request) {
        request = (GetImageSetRequest)this.beforeClientExecution(request);
        return this.executeGetImageSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetImageSetResult executeGetImageSet(GetImageSetRequest getImageSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getImageSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetImageSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetImageSetRequestProtocolMarshaller(protocolFactory).marshall((GetImageSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getImageSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetImageSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetImageSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetImageSetResult getImageSetResult = (GetImageSetResult)response.getAwsResponse();
            return getImageSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetImageSetMetadataResult getImageSetMetadata(GetImageSetMetadataRequest request) {
        request = (GetImageSetMetadataRequest)this.beforeClientExecution(request);
        return this.executeGetImageSetMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetImageSetMetadataResult executeGetImageSetMetadata(GetImageSetMetadataRequest getImageSetMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getImageSetMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetImageSetMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetImageSetMetadataRequestProtocolMarshaller(protocolFactory).marshall((GetImageSetMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getImageSetMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetImageSetMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetImageSetMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            GetImageSetMetadataResult getImageSetMetadataResult = (GetImageSetMetadataResult)response.getAwsResponse();
            return getImageSetMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDICOMImportJobsResult listDICOMImportJobs(ListDICOMImportJobsRequest request) {
        request = (ListDICOMImportJobsRequest)this.beforeClientExecution(request);
        return this.executeListDICOMImportJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDICOMImportJobsResult executeListDICOMImportJobs(ListDICOMImportJobsRequest listDICOMImportJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDICOMImportJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDICOMImportJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDICOMImportJobsRequestProtocolMarshaller(protocolFactory).marshall((ListDICOMImportJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDICOMImportJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDICOMImportJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDICOMImportJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDICOMImportJobsResult listDICOMImportJobsResult = (ListDICOMImportJobsResult)response.getAwsResponse();
            return listDICOMImportJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatastoresResult listDatastores(ListDatastoresRequest request) {
        request = (ListDatastoresRequest)this.beforeClientExecution(request);
        return this.executeListDatastores(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatastoresResult executeListDatastores(ListDatastoresRequest listDatastoresRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatastoresRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatastoresRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatastoresRequestProtocolMarshaller(protocolFactory).marshall((ListDatastoresRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatastoresRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatastores");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatastoresResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatastoresResult listDatastoresResult = (ListDatastoresResult)response.getAwsResponse();
            return listDatastoresResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListImageSetVersionsResult listImageSetVersions(ListImageSetVersionsRequest request) {
        request = (ListImageSetVersionsRequest)this.beforeClientExecution(request);
        return this.executeListImageSetVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListImageSetVersionsResult executeListImageSetVersions(ListImageSetVersionsRequest listImageSetVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listImageSetVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListImageSetVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListImageSetVersionsRequestProtocolMarshaller(protocolFactory).marshall((ListImageSetVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listImageSetVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListImageSetVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListImageSetVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListImageSetVersionsResult listImageSetVersionsResult = (ListImageSetVersionsResult)response.getAwsResponse();
            return listImageSetVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchImageSetsResult searchImageSets(SearchImageSetsRequest request) {
        request = (SearchImageSetsRequest)this.beforeClientExecution(request);
        return this.executeSearchImageSets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchImageSetsResult executeSearchImageSets(SearchImageSetsRequest searchImageSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchImageSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchImageSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchImageSetsRequestProtocolMarshaller(protocolFactory).marshall((SearchImageSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)searchImageSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SearchImageSets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchImageSetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            SearchImageSetsResult searchImageSetsResult = (SearchImageSetsResult)response.getAwsResponse();
            return searchImageSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDICOMImportJobResult startDICOMImportJob(StartDICOMImportJobRequest request) {
        request = (StartDICOMImportJobRequest)this.beforeClientExecution(request);
        return this.executeStartDICOMImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDICOMImportJobResult executeStartDICOMImportJob(StartDICOMImportJobRequest startDICOMImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDICOMImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDICOMImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDICOMImportJobRequestProtocolMarshaller(protocolFactory).marshall((StartDICOMImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDICOMImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDICOMImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDICOMImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDICOMImportJobResult startDICOMImportJobResult = (StartDICOMImportJobResult)response.getAwsResponse();
            return startDICOMImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateImageSetMetadataResult updateImageSetMetadata(UpdateImageSetMetadataRequest request) {
        request = (UpdateImageSetMetadataRequest)this.beforeClientExecution(request);
        return this.executeUpdateImageSetMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateImageSetMetadataResult executeUpdateImageSetMetadata(UpdateImageSetMetadataRequest updateImageSetMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateImageSetMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateImageSetMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateImageSetMetadataRequestProtocolMarshaller(protocolFactory).marshall((UpdateImageSetMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateImageSetMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Medical Imaging");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateImageSetMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "runtime-";
                String resolvedHostPrefix = String.format("runtime-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateImageSetMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateImageSetMetadataResult updateImageSetMetadataResult = (UpdateImageSetMetadataResult)response.getAwsResponse();
            return updateImageSetMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

