/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.TeletextPageType;
import com.amazonaws.services.mediaconvert.model.transform.TeletextDestinationSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TeletextDestinationSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String pageNumber;
    private List<String> pageTypes;

    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    public String getPageNumber() {
        return this.pageNumber;
    }

    public TeletextDestinationSettings withPageNumber(String pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public List<String> getPageTypes() {
        return this.pageTypes;
    }

    public void setPageTypes(Collection<String> pageTypes) {
        if (pageTypes == null) {
            this.pageTypes = null;
            return;
        }
        this.pageTypes = new ArrayList<String>(pageTypes);
    }

    public TeletextDestinationSettings withPageTypes(String ... pageTypes) {
        if (this.pageTypes == null) {
            this.setPageTypes(new ArrayList<String>(pageTypes.length));
        }
        for (String ele : pageTypes) {
            this.pageTypes.add(ele);
        }
        return this;
    }

    public TeletextDestinationSettings withPageTypes(Collection<String> pageTypes) {
        this.setPageTypes(pageTypes);
        return this;
    }

    public TeletextDestinationSettings withPageTypes(TeletextPageType ... pageTypes) {
        ArrayList<String> pageTypesCopy = new ArrayList<String>(pageTypes.length);
        for (TeletextPageType value : pageTypes) {
            pageTypesCopy.add(value.toString());
        }
        if (this.getPageTypes() == null) {
            this.setPageTypes(pageTypesCopy);
        } else {
            this.getPageTypes().addAll(pageTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber()).append(",");
        }
        if (this.getPageTypes() != null) {
            sb.append("PageTypes: ").append(this.getPageTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeletextDestinationSettings)) {
            return false;
        }
        TeletextDestinationSettings other = (TeletextDestinationSettings)obj;
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        if (other.getPageNumber() != null && !other.getPageNumber().equals(this.getPageNumber())) {
            return false;
        }
        if (other.getPageTypes() == null ^ this.getPageTypes() == null) {
            return false;
        }
        return other.getPageTypes() == null || other.getPageTypes().equals(this.getPageTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        hashCode = 31 * hashCode + (this.getPageTypes() == null ? 0 : this.getPageTypes().hashCode());
        return hashCode;
    }

    public TeletextDestinationSettings clone() {
        try {
            return (TeletextDestinationSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TeletextDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

