/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.transform.NetworkAccessConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkAccessConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> prefixListIds;
    private List<String> vpceIds;

    public List<String> getPrefixListIds() {
        return this.prefixListIds;
    }

    public void setPrefixListIds(Collection<String> prefixListIds) {
        if (prefixListIds == null) {
            this.prefixListIds = null;
            return;
        }
        this.prefixListIds = new ArrayList<String>(prefixListIds);
    }

    public NetworkAccessConfiguration withPrefixListIds(String ... prefixListIds) {
        if (this.prefixListIds == null) {
            this.setPrefixListIds(new ArrayList<String>(prefixListIds.length));
        }
        for (String ele : prefixListIds) {
            this.prefixListIds.add(ele);
        }
        return this;
    }

    public NetworkAccessConfiguration withPrefixListIds(Collection<String> prefixListIds) {
        this.setPrefixListIds(prefixListIds);
        return this;
    }

    public List<String> getVpceIds() {
        return this.vpceIds;
    }

    public void setVpceIds(Collection<String> vpceIds) {
        if (vpceIds == null) {
            this.vpceIds = null;
            return;
        }
        this.vpceIds = new ArrayList<String>(vpceIds);
    }

    public NetworkAccessConfiguration withVpceIds(String ... vpceIds) {
        if (this.vpceIds == null) {
            this.setVpceIds(new ArrayList<String>(vpceIds.length));
        }
        for (String ele : vpceIds) {
            this.vpceIds.add(ele);
        }
        return this;
    }

    public NetworkAccessConfiguration withVpceIds(Collection<String> vpceIds) {
        this.setVpceIds(vpceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrefixListIds() != null) {
            sb.append("PrefixListIds: ").append(this.getPrefixListIds()).append(",");
        }
        if (this.getVpceIds() != null) {
            sb.append("VpceIds: ").append(this.getVpceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAccessConfiguration)) {
            return false;
        }
        NetworkAccessConfiguration other = (NetworkAccessConfiguration)obj;
        if (other.getPrefixListIds() == null ^ this.getPrefixListIds() == null) {
            return false;
        }
        if (other.getPrefixListIds() != null && !other.getPrefixListIds().equals(this.getPrefixListIds())) {
            return false;
        }
        if (other.getVpceIds() == null ^ this.getVpceIds() == null) {
            return false;
        }
        return other.getVpceIds() == null || other.getVpceIds().equals(this.getVpceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrefixListIds() == null ? 0 : this.getPrefixListIds().hashCode());
        hashCode = 31 * hashCode + (this.getVpceIds() == null ? 0 : this.getVpceIds().hashCode());
        return hashCode;
    }

    public NetworkAccessConfiguration clone() {
        try {
            return (NetworkAccessConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkAccessConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

