/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.location.model.CalculateRouteCarModeOptions;
import com.amazonaws.services.location.model.CalculateRouteTruckModeOptions;
import com.amazonaws.services.location.model.DistanceUnit;
import com.amazonaws.services.location.model.TravelMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CalculateRouteRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String calculatorName;
    private CalculateRouteCarModeOptions carModeOptions;
    private Boolean departNow;
    private List<Double> departurePosition;
    private Date departureTime;
    private List<Double> destinationPosition;
    private String distanceUnit;
    private Boolean includeLegGeometry;
    private String travelMode;
    private CalculateRouteTruckModeOptions truckModeOptions;
    private List<List<Double>> waypointPositions;

    public void setCalculatorName(String calculatorName) {
        this.calculatorName = calculatorName;
    }

    public String getCalculatorName() {
        return this.calculatorName;
    }

    public CalculateRouteRequest withCalculatorName(String calculatorName) {
        this.setCalculatorName(calculatorName);
        return this;
    }

    public void setCarModeOptions(CalculateRouteCarModeOptions carModeOptions) {
        this.carModeOptions = carModeOptions;
    }

    public CalculateRouteCarModeOptions getCarModeOptions() {
        return this.carModeOptions;
    }

    public CalculateRouteRequest withCarModeOptions(CalculateRouteCarModeOptions carModeOptions) {
        this.setCarModeOptions(carModeOptions);
        return this;
    }

    public void setDepartNow(Boolean departNow) {
        this.departNow = departNow;
    }

    public Boolean getDepartNow() {
        return this.departNow;
    }

    public CalculateRouteRequest withDepartNow(Boolean departNow) {
        this.setDepartNow(departNow);
        return this;
    }

    public Boolean isDepartNow() {
        return this.departNow;
    }

    public List<Double> getDeparturePosition() {
        return this.departurePosition;
    }

    public void setDeparturePosition(Collection<Double> departurePosition) {
        if (departurePosition == null) {
            this.departurePosition = null;
            return;
        }
        this.departurePosition = new ArrayList<Double>(departurePosition);
    }

    public CalculateRouteRequest withDeparturePosition(Double ... departurePosition) {
        if (this.departurePosition == null) {
            this.setDeparturePosition(new ArrayList<Double>(departurePosition.length));
        }
        for (Double ele : departurePosition) {
            this.departurePosition.add(ele);
        }
        return this;
    }

    public CalculateRouteRequest withDeparturePosition(Collection<Double> departurePosition) {
        this.setDeparturePosition(departurePosition);
        return this;
    }

    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    public Date getDepartureTime() {
        return this.departureTime;
    }

    public CalculateRouteRequest withDepartureTime(Date departureTime) {
        this.setDepartureTime(departureTime);
        return this;
    }

    public List<Double> getDestinationPosition() {
        return this.destinationPosition;
    }

    public void setDestinationPosition(Collection<Double> destinationPosition) {
        if (destinationPosition == null) {
            this.destinationPosition = null;
            return;
        }
        this.destinationPosition = new ArrayList<Double>(destinationPosition);
    }

    public CalculateRouteRequest withDestinationPosition(Double ... destinationPosition) {
        if (this.destinationPosition == null) {
            this.setDestinationPosition(new ArrayList<Double>(destinationPosition.length));
        }
        for (Double ele : destinationPosition) {
            this.destinationPosition.add(ele);
        }
        return this;
    }

    public CalculateRouteRequest withDestinationPosition(Collection<Double> destinationPosition) {
        this.setDestinationPosition(destinationPosition);
        return this;
    }

    public void setDistanceUnit(String distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public String getDistanceUnit() {
        return this.distanceUnit;
    }

    public CalculateRouteRequest withDistanceUnit(String distanceUnit) {
        this.setDistanceUnit(distanceUnit);
        return this;
    }

    public CalculateRouteRequest withDistanceUnit(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit.toString();
        return this;
    }

    public void setIncludeLegGeometry(Boolean includeLegGeometry) {
        this.includeLegGeometry = includeLegGeometry;
    }

    public Boolean getIncludeLegGeometry() {
        return this.includeLegGeometry;
    }

    public CalculateRouteRequest withIncludeLegGeometry(Boolean includeLegGeometry) {
        this.setIncludeLegGeometry(includeLegGeometry);
        return this;
    }

    public Boolean isIncludeLegGeometry() {
        return this.includeLegGeometry;
    }

    public void setTravelMode(String travelMode) {
        this.travelMode = travelMode;
    }

    public String getTravelMode() {
        return this.travelMode;
    }

    public CalculateRouteRequest withTravelMode(String travelMode) {
        this.setTravelMode(travelMode);
        return this;
    }

    public CalculateRouteRequest withTravelMode(TravelMode travelMode) {
        this.travelMode = travelMode.toString();
        return this;
    }

    public void setTruckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
        this.truckModeOptions = truckModeOptions;
    }

    public CalculateRouteTruckModeOptions getTruckModeOptions() {
        return this.truckModeOptions;
    }

    public CalculateRouteRequest withTruckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
        this.setTruckModeOptions(truckModeOptions);
        return this;
    }

    public List<List<Double>> getWaypointPositions() {
        return this.waypointPositions;
    }

    public void setWaypointPositions(Collection<List<Double>> waypointPositions) {
        if (waypointPositions == null) {
            this.waypointPositions = null;
            return;
        }
        this.waypointPositions = new ArrayList<List<Double>>(waypointPositions);
    }

    public CalculateRouteRequest withWaypointPositions(List<Double> ... waypointPositions) {
        if (this.waypointPositions == null) {
            this.setWaypointPositions(new ArrayList<List<Double>>(waypointPositions.length));
        }
        for (List<Double> ele : waypointPositions) {
            this.waypointPositions.add(ele);
        }
        return this;
    }

    public CalculateRouteRequest withWaypointPositions(Collection<List<Double>> waypointPositions) {
        this.setWaypointPositions(waypointPositions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCalculatorName() != null) {
            sb.append("CalculatorName: ").append(this.getCalculatorName()).append(",");
        }
        if (this.getCarModeOptions() != null) {
            sb.append("CarModeOptions: ").append(this.getCarModeOptions()).append(",");
        }
        if (this.getDepartNow() != null) {
            sb.append("DepartNow: ").append(this.getDepartNow()).append(",");
        }
        if (this.getDeparturePosition() != null) {
            sb.append("DeparturePosition: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDepartureTime() != null) {
            sb.append("DepartureTime: ").append(this.getDepartureTime()).append(",");
        }
        if (this.getDestinationPosition() != null) {
            sb.append("DestinationPosition: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDistanceUnit() != null) {
            sb.append("DistanceUnit: ").append(this.getDistanceUnit()).append(",");
        }
        if (this.getIncludeLegGeometry() != null) {
            sb.append("IncludeLegGeometry: ").append(this.getIncludeLegGeometry()).append(",");
        }
        if (this.getTravelMode() != null) {
            sb.append("TravelMode: ").append(this.getTravelMode()).append(",");
        }
        if (this.getTruckModeOptions() != null) {
            sb.append("TruckModeOptions: ").append(this.getTruckModeOptions()).append(",");
        }
        if (this.getWaypointPositions() != null) {
            sb.append("WaypointPositions: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteRequest)) {
            return false;
        }
        CalculateRouteRequest other = (CalculateRouteRequest)obj;
        if (other.getCalculatorName() == null ^ this.getCalculatorName() == null) {
            return false;
        }
        if (other.getCalculatorName() != null && !other.getCalculatorName().equals(this.getCalculatorName())) {
            return false;
        }
        if (other.getCarModeOptions() == null ^ this.getCarModeOptions() == null) {
            return false;
        }
        if (other.getCarModeOptions() != null && !other.getCarModeOptions().equals(this.getCarModeOptions())) {
            return false;
        }
        if (other.getDepartNow() == null ^ this.getDepartNow() == null) {
            return false;
        }
        if (other.getDepartNow() != null && !other.getDepartNow().equals(this.getDepartNow())) {
            return false;
        }
        if (other.getDeparturePosition() == null ^ this.getDeparturePosition() == null) {
            return false;
        }
        if (other.getDeparturePosition() != null && !other.getDeparturePosition().equals(this.getDeparturePosition())) {
            return false;
        }
        if (other.getDepartureTime() == null ^ this.getDepartureTime() == null) {
            return false;
        }
        if (other.getDepartureTime() != null && !other.getDepartureTime().equals(this.getDepartureTime())) {
            return false;
        }
        if (other.getDestinationPosition() == null ^ this.getDestinationPosition() == null) {
            return false;
        }
        if (other.getDestinationPosition() != null && !other.getDestinationPosition().equals(this.getDestinationPosition())) {
            return false;
        }
        if (other.getDistanceUnit() == null ^ this.getDistanceUnit() == null) {
            return false;
        }
        if (other.getDistanceUnit() != null && !other.getDistanceUnit().equals(this.getDistanceUnit())) {
            return false;
        }
        if (other.getIncludeLegGeometry() == null ^ this.getIncludeLegGeometry() == null) {
            return false;
        }
        if (other.getIncludeLegGeometry() != null && !other.getIncludeLegGeometry().equals(this.getIncludeLegGeometry())) {
            return false;
        }
        if (other.getTravelMode() == null ^ this.getTravelMode() == null) {
            return false;
        }
        if (other.getTravelMode() != null && !other.getTravelMode().equals(this.getTravelMode())) {
            return false;
        }
        if (other.getTruckModeOptions() == null ^ this.getTruckModeOptions() == null) {
            return false;
        }
        if (other.getTruckModeOptions() != null && !other.getTruckModeOptions().equals(this.getTruckModeOptions())) {
            return false;
        }
        if (other.getWaypointPositions() == null ^ this.getWaypointPositions() == null) {
            return false;
        }
        return other.getWaypointPositions() == null || other.getWaypointPositions().equals(this.getWaypointPositions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCalculatorName() == null ? 0 : this.getCalculatorName().hashCode());
        hashCode = 31 * hashCode + (this.getCarModeOptions() == null ? 0 : this.getCarModeOptions().hashCode());
        hashCode = 31 * hashCode + (this.getDepartNow() == null ? 0 : this.getDepartNow().hashCode());
        hashCode = 31 * hashCode + (this.getDeparturePosition() == null ? 0 : this.getDeparturePosition().hashCode());
        hashCode = 31 * hashCode + (this.getDepartureTime() == null ? 0 : this.getDepartureTime().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPosition() == null ? 0 : this.getDestinationPosition().hashCode());
        hashCode = 31 * hashCode + (this.getDistanceUnit() == null ? 0 : this.getDistanceUnit().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeLegGeometry() == null ? 0 : this.getIncludeLegGeometry().hashCode());
        hashCode = 31 * hashCode + (this.getTravelMode() == null ? 0 : this.getTravelMode().hashCode());
        hashCode = 31 * hashCode + (this.getTruckModeOptions() == null ? 0 : this.getTruckModeOptions().hashCode());
        hashCode = 31 * hashCode + (this.getWaypointPositions() == null ? 0 : this.getWaypointPositions().hashCode());
        return hashCode;
    }

    public CalculateRouteRequest clone() {
        return (CalculateRouteRequest)super.clone();
    }
}

