/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lightsail.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Returns information that was submitted during the <code>SetupInstanceHttps</code> request. Email information is
 * redacted for privacy.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetupRequest" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SetupRequest implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the Lightsail instance.
     * </p>
     */
    private String instanceName;
    /**
     * <p>
     * The name of the domain and subdomains that the SSL/TLS certificate secures.
     * </p>
     */
    private java.util.List<String> domainNames;
    /**
     * <p>
     * The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * </p>
     */
    private String certificateProvider;

    /**
     * <p>
     * The name of the Lightsail instance.
     * </p>
     * 
     * @param instanceName
     *        The name of the Lightsail instance.
     */

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    /**
     * <p>
     * The name of the Lightsail instance.
     * </p>
     * 
     * @return The name of the Lightsail instance.
     */

    public String getInstanceName() {
        return this.instanceName;
    }

    /**
     * <p>
     * The name of the Lightsail instance.
     * </p>
     * 
     * @param instanceName
     *        The name of the Lightsail instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SetupRequest withInstanceName(String instanceName) {
        setInstanceName(instanceName);
        return this;
    }

    /**
     * <p>
     * The name of the domain and subdomains that the SSL/TLS certificate secures.
     * </p>
     * 
     * @return The name of the domain and subdomains that the SSL/TLS certificate secures.
     */

    public java.util.List<String> getDomainNames() {
        return domainNames;
    }

    /**
     * <p>
     * The name of the domain and subdomains that the SSL/TLS certificate secures.
     * </p>
     * 
     * @param domainNames
     *        The name of the domain and subdomains that the SSL/TLS certificate secures.
     */

    public void setDomainNames(java.util.Collection<String> domainNames) {
        if (domainNames == null) {
            this.domainNames = null;
            return;
        }

        this.domainNames = new java.util.ArrayList<String>(domainNames);
    }

    /**
     * <p>
     * The name of the domain and subdomains that the SSL/TLS certificate secures.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDomainNames(java.util.Collection)} or {@link #withDomainNames(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param domainNames
     *        The name of the domain and subdomains that the SSL/TLS certificate secures.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SetupRequest withDomainNames(String... domainNames) {
        if (this.domainNames == null) {
            setDomainNames(new java.util.ArrayList<String>(domainNames.length));
        }
        for (String ele : domainNames) {
            this.domainNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the domain and subdomains that the SSL/TLS certificate secures.
     * </p>
     * 
     * @param domainNames
     *        The name of the domain and subdomains that the SSL/TLS certificate secures.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SetupRequest withDomainNames(java.util.Collection<String> domainNames) {
        setDomainNames(domainNames);
        return this;
    }

    /**
     * <p>
     * The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * </p>
     * 
     * @param certificateProvider
     *        The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * @see CertificateProvider
     */

    public void setCertificateProvider(String certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    /**
     * <p>
     * The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * </p>
     * 
     * @return The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * @see CertificateProvider
     */

    public String getCertificateProvider() {
        return this.certificateProvider;
    }

    /**
     * <p>
     * The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * </p>
     * 
     * @param certificateProvider
     *        The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CertificateProvider
     */

    public SetupRequest withCertificateProvider(String certificateProvider) {
        setCertificateProvider(certificateProvider);
        return this;
    }

    /**
     * <p>
     * The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * </p>
     * 
     * @param certificateProvider
     *        The Certificate Authority (CA) that issues the SSL/TLS certificate.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CertificateProvider
     */

    public SetupRequest withCertificateProvider(CertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceName() != null)
            sb.append("InstanceName: ").append(getInstanceName()).append(",");
        if (getDomainNames() != null)
            sb.append("DomainNames: ").append(getDomainNames()).append(",");
        if (getCertificateProvider() != null)
            sb.append("CertificateProvider: ").append(getCertificateProvider());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SetupRequest == false)
            return false;
        SetupRequest other = (SetupRequest) obj;
        if (other.getInstanceName() == null ^ this.getInstanceName() == null)
            return false;
        if (other.getInstanceName() != null && other.getInstanceName().equals(this.getInstanceName()) == false)
            return false;
        if (other.getDomainNames() == null ^ this.getDomainNames() == null)
            return false;
        if (other.getDomainNames() != null && other.getDomainNames().equals(this.getDomainNames()) == false)
            return false;
        if (other.getCertificateProvider() == null ^ this.getCertificateProvider() == null)
            return false;
        if (other.getCertificateProvider() != null && other.getCertificateProvider().equals(this.getCertificateProvider()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceName() == null) ? 0 : getInstanceName().hashCode());
        hashCode = prime * hashCode + ((getDomainNames() == null) ? 0 : getDomainNames().hashCode());
        hashCode = prime * hashCode + ((getCertificateProvider() == null) ? 0 : getCertificateProvider().hashCode());
        return hashCode;
    }

    @Override
    public SetupRequest clone() {
        try {
            return (SetupRequest) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lightsail.model.transform.SetupRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
