/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.ComponentPropertyGroupResponse;
import com.amazonaws.services.iottwinmaker.model.PropertyResponse;
import com.amazonaws.services.iottwinmaker.model.Status;
import com.amazonaws.services.iottwinmaker.model.transform.ComponentResponseMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComponentResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentName;
    private String description;
    private String componentTypeId;
    private Status status;
    private String definedIn;
    private Map<String, PropertyResponse> properties;
    private Map<String, ComponentPropertyGroupResponse> propertyGroups;
    private String syncSource;

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ComponentResponse withComponentName(String componentName) {
        this.setComponentName(componentName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ComponentResponse withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setComponentTypeId(String componentTypeId) {
        this.componentTypeId = componentTypeId;
    }

    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public ComponentResponse withComponentTypeId(String componentTypeId) {
        this.setComponentTypeId(componentTypeId);
        return this;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public ComponentResponse withStatus(Status status) {
        this.setStatus(status);
        return this;
    }

    public void setDefinedIn(String definedIn) {
        this.definedIn = definedIn;
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public ComponentResponse withDefinedIn(String definedIn) {
        this.setDefinedIn(definedIn);
        return this;
    }

    public Map<String, PropertyResponse> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, PropertyResponse> properties) {
        this.properties = properties;
    }

    public ComponentResponse withProperties(Map<String, PropertyResponse> properties) {
        this.setProperties(properties);
        return this;
    }

    public ComponentResponse addPropertiesEntry(String key, PropertyResponse value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, PropertyResponse>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public ComponentResponse clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public Map<String, ComponentPropertyGroupResponse> getPropertyGroups() {
        return this.propertyGroups;
    }

    public void setPropertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups) {
        this.propertyGroups = propertyGroups;
    }

    public ComponentResponse withPropertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups) {
        this.setPropertyGroups(propertyGroups);
        return this;
    }

    public ComponentResponse addPropertyGroupsEntry(String key, ComponentPropertyGroupResponse value) {
        if (null == this.propertyGroups) {
            this.propertyGroups = new HashMap<String, ComponentPropertyGroupResponse>();
        }
        if (this.propertyGroups.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.propertyGroups.put(key, value);
        return this;
    }

    public ComponentResponse clearPropertyGroupsEntries() {
        this.propertyGroups = null;
        return this;
    }

    public void setSyncSource(String syncSource) {
        this.syncSource = syncSource;
    }

    public String getSyncSource() {
        return this.syncSource;
    }

    public ComponentResponse withSyncSource(String syncSource) {
        this.setSyncSource(syncSource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentName() != null) {
            sb.append("ComponentName: ").append(this.getComponentName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getComponentTypeId() != null) {
            sb.append("ComponentTypeId: ").append(this.getComponentTypeId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDefinedIn() != null) {
            sb.append("DefinedIn: ").append(this.getDefinedIn()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getPropertyGroups() != null) {
            sb.append("PropertyGroups: ").append(this.getPropertyGroups()).append(",");
        }
        if (this.getSyncSource() != null) {
            sb.append("SyncSource: ").append(this.getSyncSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentResponse)) {
            return false;
        }
        ComponentResponse other = (ComponentResponse)obj;
        if (other.getComponentName() == null ^ this.getComponentName() == null) {
            return false;
        }
        if (other.getComponentName() != null && !other.getComponentName().equals(this.getComponentName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getComponentTypeId() == null ^ this.getComponentTypeId() == null) {
            return false;
        }
        if (other.getComponentTypeId() != null && !other.getComponentTypeId().equals(this.getComponentTypeId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDefinedIn() == null ^ this.getDefinedIn() == null) {
            return false;
        }
        if (other.getDefinedIn() != null && !other.getDefinedIn().equals(this.getDefinedIn())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getPropertyGroups() == null ^ this.getPropertyGroups() == null) {
            return false;
        }
        if (other.getPropertyGroups() != null && !other.getPropertyGroups().equals(this.getPropertyGroups())) {
            return false;
        }
        if (other.getSyncSource() == null ^ this.getSyncSource() == null) {
            return false;
        }
        return other.getSyncSource() == null || other.getSyncSource().equals(this.getSyncSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentName() == null ? 0 : this.getComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getComponentTypeId() == null ? 0 : this.getComponentTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDefinedIn() == null ? 0 : this.getDefinedIn().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyGroups() == null ? 0 : this.getPropertyGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSyncSource() == null ? 0 : this.getSyncSource().hashCode());
        return hashCode;
    }

    public ComponentResponse clone() {
        try {
            return (ComponentResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

