/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.OnWorkflowFailure;
import com.amazonaws.services.imagebuilder.model.WorkflowParameter;
import com.amazonaws.services.imagebuilder.model.transform.WorkflowConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkflowConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String workflowArn;
    private List<WorkflowParameter> parameters;
    private String parallelGroup;
    private String onFailure;

    public void setWorkflowArn(String workflowArn) {
        this.workflowArn = workflowArn;
    }

    public String getWorkflowArn() {
        return this.workflowArn;
    }

    public WorkflowConfiguration withWorkflowArn(String workflowArn) {
        this.setWorkflowArn(workflowArn);
        return this;
    }

    public List<WorkflowParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<WorkflowParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<WorkflowParameter>(parameters);
    }

    public WorkflowConfiguration withParameters(WorkflowParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<WorkflowParameter>(parameters.length));
        }
        for (WorkflowParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public WorkflowConfiguration withParameters(Collection<WorkflowParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setParallelGroup(String parallelGroup) {
        this.parallelGroup = parallelGroup;
    }

    public String getParallelGroup() {
        return this.parallelGroup;
    }

    public WorkflowConfiguration withParallelGroup(String parallelGroup) {
        this.setParallelGroup(parallelGroup);
        return this;
    }

    public void setOnFailure(String onFailure) {
        this.onFailure = onFailure;
    }

    public String getOnFailure() {
        return this.onFailure;
    }

    public WorkflowConfiguration withOnFailure(String onFailure) {
        this.setOnFailure(onFailure);
        return this;
    }

    public WorkflowConfiguration withOnFailure(OnWorkflowFailure onFailure) {
        this.onFailure = onFailure.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkflowArn() != null) {
            sb.append("WorkflowArn: ").append(this.getWorkflowArn()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getParallelGroup() != null) {
            sb.append("ParallelGroup: ").append(this.getParallelGroup()).append(",");
        }
        if (this.getOnFailure() != null) {
            sb.append("OnFailure: ").append(this.getOnFailure());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowConfiguration)) {
            return false;
        }
        WorkflowConfiguration other = (WorkflowConfiguration)obj;
        if (other.getWorkflowArn() == null ^ this.getWorkflowArn() == null) {
            return false;
        }
        if (other.getWorkflowArn() != null && !other.getWorkflowArn().equals(this.getWorkflowArn())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getParallelGroup() == null ^ this.getParallelGroup() == null) {
            return false;
        }
        if (other.getParallelGroup() != null && !other.getParallelGroup().equals(this.getParallelGroup())) {
            return false;
        }
        if (other.getOnFailure() == null ^ this.getOnFailure() == null) {
            return false;
        }
        return other.getOnFailure() == null || other.getOnFailure().equals(this.getOnFailure());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkflowArn() == null ? 0 : this.getWorkflowArn().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getParallelGroup() == null ? 0 : this.getParallelGroup().hashCode());
        hashCode = 31 * hashCode + (this.getOnFailure() == null ? 0 : this.getOnFailure().hashCode());
        return hashCode;
    }

    public WorkflowConfiguration clone() {
        try {
            return (WorkflowConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

