/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentOptions;
import com.amazonaws.services.fis.model.ExperimentState;
import com.amazonaws.services.fis.model.transform.ExperimentSummaryMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExperimentSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private String experimentTemplateId;
    private ExperimentState state;
    private Date creationTime;
    private Map<String, String> tags;
    private ExperimentOptions experimentOptions;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ExperimentSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ExperimentSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setExperimentTemplateId(String experimentTemplateId) {
        this.experimentTemplateId = experimentTemplateId;
    }

    public String getExperimentTemplateId() {
        return this.experimentTemplateId;
    }

    public ExperimentSummary withExperimentTemplateId(String experimentTemplateId) {
        this.setExperimentTemplateId(experimentTemplateId);
        return this;
    }

    public void setState(ExperimentState state) {
        this.state = state;
    }

    public ExperimentState getState() {
        return this.state;
    }

    public ExperimentSummary withState(ExperimentState state) {
        this.setState(state);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ExperimentSummary withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ExperimentSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ExperimentSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ExperimentSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setExperimentOptions(ExperimentOptions experimentOptions) {
        this.experimentOptions = experimentOptions;
    }

    public ExperimentOptions getExperimentOptions() {
        return this.experimentOptions;
    }

    public ExperimentSummary withExperimentOptions(ExperimentOptions experimentOptions) {
        this.setExperimentOptions(experimentOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getExperimentTemplateId() != null) {
            sb.append("ExperimentTemplateId: ").append(this.getExperimentTemplateId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getExperimentOptions() != null) {
            sb.append("ExperimentOptions: ").append(this.getExperimentOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentSummary)) {
            return false;
        }
        ExperimentSummary other = (ExperimentSummary)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getExperimentTemplateId() == null ^ this.getExperimentTemplateId() == null) {
            return false;
        }
        if (other.getExperimentTemplateId() != null && !other.getExperimentTemplateId().equals(this.getExperimentTemplateId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getExperimentOptions() == null ^ this.getExperimentOptions() == null) {
            return false;
        }
        return other.getExperimentOptions() == null || other.getExperimentOptions().equals(this.getExperimentOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentTemplateId() == null ? 0 : this.getExperimentTemplateId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentOptions() == null ? 0 : this.getExperimentOptions().hashCode());
        return hashCode;
    }

    public ExperimentSummary clone() {
        try {
            return (ExperimentSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

