/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MatcherStaxUnmarshaller
implements Unmarshaller<Matcher, StaxUnmarshallerContext> {
    private static MatcherStaxUnmarshaller instance;

    public Matcher unmarshall(StaxUnmarshallerContext context) throws Exception {
        Matcher matcher = new Matcher();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return matcher;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HttpCode", targetDepth)) {
                    matcher.setHttpCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("GrpcCode", targetDepth)) continue;
                matcher.setGrpcCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return matcher;
    }

    public static MatcherStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MatcherStaxUnmarshaller();
        }
        return instance;
    }
}

