/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SetSubnetsRequestMarshaller
implements Marshaller<Request<SetSubnetsRequest>, SetSubnetsRequest> {
    public Request<SetSubnetsRequest> marshall(SetSubnetsRequest setSubnetsRequest) {
        List<String> subnetsList;
        if (setSubnetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSubnetsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "SetSubnets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSubnetsRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)setSubnetsRequest.getLoadBalancerArn()));
        }
        if ((subnetsList = setSubnetsRequest.getSubnets()) != null) {
            if (subnetsList.isEmpty()) {
                request.addParameter("Subnets", "");
            } else {
                int subnetsListIndex = 1;
                for (String subnetsListValue : subnetsList) {
                    if (subnetsListValue != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)subnetsListValue));
                    }
                    ++subnetsListIndex;
                }
            }
        }
        return request;
    }
}

