/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.Rule;
import com.amazonaws.services.elasticloadbalancingv2.model.transform.ActionStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancingv2.model.transform.RuleConditionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RuleStaxUnmarshaller
implements Unmarshaller<Rule, StaxUnmarshallerContext> {
    private static RuleStaxUnmarshaller instance;

    public Rule unmarshall(StaxUnmarshallerContext context) throws Exception {
        Rule rule = new Rule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return rule;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RuleArn", targetDepth)) {
                    rule.setRuleArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Priority", targetDepth)) {
                    rule.setPriority(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Conditions/member", targetDepth)) {
                    rule.withConditions(RuleConditionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Actions/member", targetDepth)) {
                    rule.withActions(ActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsDefault", targetDepth)) continue;
                rule.setIsDefault(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return rule;
    }

    public static RuleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RuleStaxUnmarshaller();
        }
        return instance;
    }
}

