/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.services.ecs.model.transform.ContainerOverrideJsonMarshaller;

public class TaskOverrideJsonMarshaller {
    private static TaskOverrideJsonMarshaller instance;

    public void marshall(TaskOverride taskOverride, StructuredJsonGenerator jsonGenerator) {
        if (taskOverride == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList containerOverridesList = (SdkInternalList)taskOverride.getContainerOverrides();
            if (!containerOverridesList.isEmpty() || !containerOverridesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("containerOverrides");
                jsonGenerator.writeStartArray();
                for (ContainerOverride containerOverridesListValue : containerOverridesList) {
                    if (containerOverridesListValue == null) continue;
                    ContainerOverrideJsonMarshaller.getInstance().marshall(containerOverridesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (taskOverride.getTaskRoleArn() != null) {
                jsonGenerator.writeFieldName("taskRoleArn").writeValue(taskOverride.getTaskRoleArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskOverrideJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskOverrideJsonMarshaller();
        }
        return instance;
    }
}

