/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeLockedSnapshotsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLockedSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeLockedSnapshotsRequest>, DescribeLockedSnapshotsRequest> {
    public Request<DescribeLockedSnapshotsRequest> marshall(DescribeLockedSnapshotsRequest describeLockedSnapshotsRequest) {
        SdkInternalList describeLockedSnapshotsRequestSnapshotIdsList;
        if (describeLockedSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLockedSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeLockedSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeLockedSnapshotsRequestFiltersList = (SdkInternalList)describeLockedSnapshotsRequest.getFilters();
        if (!describeLockedSnapshotsRequestFiltersList.isEmpty() || !describeLockedSnapshotsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeLockedSnapshotsRequestFiltersListValue : describeLockedSnapshotsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeLockedSnapshotsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeLockedSnapshotsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeLockedSnapshotsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeLockedSnapshotsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeLockedSnapshotsRequest.getMaxResults()));
        }
        if (describeLockedSnapshotsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeLockedSnapshotsRequest.getNextToken()));
        }
        if (!(describeLockedSnapshotsRequestSnapshotIdsList = (SdkInternalList)describeLockedSnapshotsRequest.getSnapshotIds()).isEmpty() || !describeLockedSnapshotsRequestSnapshotIdsList.isAutoConstruct()) {
            int snapshotIdsListIndex = 1;
            for (String describeLockedSnapshotsRequestSnapshotIdsListValue : describeLockedSnapshotsRequestSnapshotIdsList) {
                if (describeLockedSnapshotsRequestSnapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString((String)describeLockedSnapshotsRequestSnapshotIdsListValue));
                }
                ++snapshotIdsListIndex;
            }
        }
        return request;
    }
}

