/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostReservationOfferingsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostReservationOfferingsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationOfferingsRequest>, DescribeHostReservationOfferingsRequest> {
    public Request<DescribeHostReservationOfferingsRequest> marshall(DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {
        SdkInternalList describeHostReservationOfferingsRequestFilterList;
        if (describeHostReservationOfferingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostReservationOfferingsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHostReservationOfferings");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHostReservationOfferingsRequest.getOfferingId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString((String)describeHostReservationOfferingsRequest.getOfferingId()));
        }
        if (describeHostReservationOfferingsRequest.getMinDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromInteger((Integer)describeHostReservationOfferingsRequest.getMinDuration()));
        }
        if (describeHostReservationOfferingsRequest.getMaxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromInteger((Integer)describeHostReservationOfferingsRequest.getMaxDuration()));
        }
        if (!(describeHostReservationOfferingsRequestFilterList = (SdkInternalList)describeHostReservationOfferingsRequest.getFilter()).isEmpty() || !describeHostReservationOfferingsRequestFilterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter describeHostReservationOfferingsRequestFilterListValue : describeHostReservationOfferingsRequestFilterList) {
                SdkInternalList filterValuesList;
                if (describeHostReservationOfferingsRequestFilterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeHostReservationOfferingsRequestFilterListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeHostReservationOfferingsRequestFilterListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeHostReservationOfferingsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostReservationOfferingsRequest.getMaxResults()));
        }
        if (describeHostReservationOfferingsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostReservationOfferingsRequest.getNextToken()));
        }
        return request;
    }
}

