/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.xspec;

import com.amazonaws.annotation.Beta;
import com.amazonaws.services.dynamodbv2.xspec.Condition;
import com.amazonaws.services.dynamodbv2.xspec.Operand;
import com.amazonaws.services.dynamodbv2.xspec.Precedence;
import com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;

@Beta
public final class ComparatorCondition
extends Condition {
    private final String comparator;
    private final Operand lhs;
    private final Operand rhs;

    ComparatorCondition(String comparator, Operand lhs, Operand rhs) {
        this.comparator = comparator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    String asSubstituted(SubstitutionContext context) {
        return this.lhs.asSubstituted(context) + " " + this.comparator + " " + this.rhs.asSubstituted(context);
    }

    @Override
    boolean atomic() {
        return true;
    }

    @Override
    int precedence() {
        return Precedence.Comparator.value();
    }
}

