/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice;

import javax.annotation.Generated;

import com.amazonaws.services.databasemigrationservice.model.*;
import com.amazonaws.*;
import com.amazonaws.services.databasemigrationservice.waiters.AWSDatabaseMigrationServiceWaiters;

/**
 * Abstract implementation of {@code AWSDatabaseMigrationService}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSDatabaseMigrationService implements AWSDatabaseMigrationService {

    protected AbstractAWSDatabaseMigrationService() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddTagsToResourceResult addTagsToResource(AddTagsToResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ApplyPendingMaintenanceActionResult applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchStartRecommendationsResult batchStartRecommendations(BatchStartRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelReplicationTaskAssessmentRunResult cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataProviderResult createDataProvider(CreateDataProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointResult createEndpoint(CreateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEventSubscriptionResult createEventSubscription(CreateEventSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFleetAdvisorCollectorResult createFleetAdvisorCollector(CreateFleetAdvisorCollectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInstanceProfileResult createInstanceProfile(CreateInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMigrationProjectResult createMigrationProject(CreateMigrationProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicationConfigResult createReplicationConfig(CreateReplicationConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicationInstanceResult createReplicationInstance(CreateReplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicationSubnetGroupResult createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicationTaskResult createReplicationTask(CreateReplicationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCertificateResult deleteCertificate(DeleteCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataProviderResult deleteDataProvider(DeleteDataProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointResult deleteEndpoint(DeleteEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventSubscriptionResult deleteEventSubscription(DeleteEventSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetAdvisorCollectorResult deleteFleetAdvisorCollector(DeleteFleetAdvisorCollectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetAdvisorDatabasesResult deleteFleetAdvisorDatabases(DeleteFleetAdvisorDatabasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInstanceProfileResult deleteInstanceProfile(DeleteInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMigrationProjectResult deleteMigrationProject(DeleteMigrationProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationConfigResult deleteReplicationConfig(DeleteReplicationConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationInstanceResult deleteReplicationInstance(DeleteReplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationSubnetGroupResult deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationTaskResult deleteReplicationTask(DeleteReplicationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationTaskAssessmentRunResult deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountAttributesResult describeAccountAttributes(DescribeAccountAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicableIndividualAssessmentsResult describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCertificatesResult describeCertificates(DescribeCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectionsResult describeConnections(DescribeConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConversionConfigurationResult describeConversionConfiguration(DescribeConversionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataProvidersResult describeDataProviders(DescribeDataProvidersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointSettingsResult describeEndpointSettings(DescribeEndpointSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointTypesResult describeEndpointTypes(DescribeEndpointTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointsResult describeEndpoints(DescribeEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEngineVersionsResult describeEngineVersions(DescribeEngineVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEventCategoriesResult describeEventCategories(DescribeEventCategoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEventSubscriptionsResult describeEventSubscriptions(DescribeEventSubscriptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeExtensionPackAssociationsResult describeExtensionPackAssociations(DescribeExtensionPackAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetAdvisorCollectorsResult describeFleetAdvisorCollectors(DescribeFleetAdvisorCollectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetAdvisorDatabasesResult describeFleetAdvisorDatabases(DescribeFleetAdvisorDatabasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetAdvisorLsaAnalysisResult describeFleetAdvisorLsaAnalysis(DescribeFleetAdvisorLsaAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetAdvisorSchemaObjectSummaryResult describeFleetAdvisorSchemaObjectSummary(DescribeFleetAdvisorSchemaObjectSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetAdvisorSchemasResult describeFleetAdvisorSchemas(DescribeFleetAdvisorSchemasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstanceProfilesResult describeInstanceProfiles(DescribeInstanceProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMetadataModelAssessmentsResult describeMetadataModelAssessments(DescribeMetadataModelAssessmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMetadataModelConversionsResult describeMetadataModelConversions(DescribeMetadataModelConversionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMetadataModelExportsAsScriptResult describeMetadataModelExportsAsScript(DescribeMetadataModelExportsAsScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMetadataModelExportsToTargetResult describeMetadataModelExportsToTarget(DescribeMetadataModelExportsToTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMetadataModelImportsResult describeMetadataModelImports(DescribeMetadataModelImportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMigrationProjectsResult describeMigrationProjects(DescribeMigrationProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrderableReplicationInstancesResult describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePendingMaintenanceActionsResult describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRecommendationLimitationsResult describeRecommendationLimitations(DescribeRecommendationLimitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRecommendationsResult describeRecommendations(DescribeRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRefreshSchemasStatusResult describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationConfigsResult describeReplicationConfigs(DescribeReplicationConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationInstanceTaskLogsResult describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationInstancesResult describeReplicationInstances(DescribeReplicationInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationSubnetGroupsResult describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationTableStatisticsResult describeReplicationTableStatistics(DescribeReplicationTableStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationTaskAssessmentResultsResult describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationTaskAssessmentRunsResult describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationTaskIndividualAssessmentsResult describeReplicationTaskIndividualAssessments(
            DescribeReplicationTaskIndividualAssessmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationTasksResult describeReplicationTasks(DescribeReplicationTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationsResult describeReplications(DescribeReplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSchemasResult describeSchemas(DescribeSchemasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTableStatisticsResult describeTableStatistics(DescribeTableStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportMetadataModelAssessmentResult exportMetadataModelAssessment(ExportMetadataModelAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportCertificateResult importCertificate(ImportCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyConversionConfigurationResult modifyConversionConfiguration(ModifyConversionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyDataProviderResult modifyDataProvider(ModifyDataProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyEndpointResult modifyEndpoint(ModifyEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyEventSubscriptionResult modifyEventSubscription(ModifyEventSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyInstanceProfileResult modifyInstanceProfile(ModifyInstanceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyMigrationProjectResult modifyMigrationProject(ModifyMigrationProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyReplicationConfigResult modifyReplicationConfig(ModifyReplicationConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyReplicationInstanceResult modifyReplicationInstance(ModifyReplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyReplicationSubnetGroupResult modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyReplicationTaskResult modifyReplicationTask(ModifyReplicationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public MoveReplicationTaskResult moveReplicationTask(MoveReplicationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RebootReplicationInstanceResult rebootReplicationInstance(RebootReplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RefreshSchemasResult refreshSchemas(RefreshSchemasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ReloadReplicationTablesResult reloadReplicationTables(ReloadReplicationTablesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ReloadTablesResult reloadTables(ReloadTablesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTagsFromResourceResult removeTagsFromResource(RemoveTagsFromResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RunFleetAdvisorLsaAnalysisResult runFleetAdvisorLsaAnalysis(RunFleetAdvisorLsaAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartExtensionPackAssociationResult startExtensionPackAssociation(StartExtensionPackAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMetadataModelAssessmentResult startMetadataModelAssessment(StartMetadataModelAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMetadataModelConversionResult startMetadataModelConversion(StartMetadataModelConversionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMetadataModelExportAsScriptResult startMetadataModelExportAsScript(StartMetadataModelExportAsScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMetadataModelExportToTargetResult startMetadataModelExportToTarget(StartMetadataModelExportToTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMetadataModelImportResult startMetadataModelImport(StartMetadataModelImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartRecommendationsResult startRecommendations(StartRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReplicationResult startReplication(StartReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReplicationTaskResult startReplicationTask(StartReplicationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReplicationTaskAssessmentResult startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReplicationTaskAssessmentRunResult startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopReplicationResult stopReplication(StopReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopReplicationTaskResult stopReplicationTask(StopReplicationTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestConnectionResult testConnection(TestConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriptionsToEventBridgeResult updateSubscriptionsToEventBridge(UpdateSubscriptionsToEventBridgeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSDatabaseMigrationServiceWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
