/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteBudgetRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The budget ID of the budget to delete.
     * </p>
     */
    private String budgetId;
    /**
     * <p>
     * The farm ID of the farm to remove from the budget.
     * </p>
     */
    private String farmId;

    /**
     * <p>
     * The budget ID of the budget to delete.
     * </p>
     * 
     * @param budgetId
     *        The budget ID of the budget to delete.
     */

    public void setBudgetId(String budgetId) {
        this.budgetId = budgetId;
    }

    /**
     * <p>
     * The budget ID of the budget to delete.
     * </p>
     * 
     * @return The budget ID of the budget to delete.
     */

    public String getBudgetId() {
        return this.budgetId;
    }

    /**
     * <p>
     * The budget ID of the budget to delete.
     * </p>
     * 
     * @param budgetId
     *        The budget ID of the budget to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteBudgetRequest withBudgetId(String budgetId) {
        setBudgetId(budgetId);
        return this;
    }

    /**
     * <p>
     * The farm ID of the farm to remove from the budget.
     * </p>
     * 
     * @param farmId
     *        The farm ID of the farm to remove from the budget.
     */

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    /**
     * <p>
     * The farm ID of the farm to remove from the budget.
     * </p>
     * 
     * @return The farm ID of the farm to remove from the budget.
     */

    public String getFarmId() {
        return this.farmId;
    }

    /**
     * <p>
     * The farm ID of the farm to remove from the budget.
     * </p>
     * 
     * @param farmId
     *        The farm ID of the farm to remove from the budget.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteBudgetRequest withFarmId(String farmId) {
        setFarmId(farmId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBudgetId() != null)
            sb.append("BudgetId: ").append(getBudgetId()).append(",");
        if (getFarmId() != null)
            sb.append("FarmId: ").append(getFarmId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteBudgetRequest == false)
            return false;
        DeleteBudgetRequest other = (DeleteBudgetRequest) obj;
        if (other.getBudgetId() == null ^ this.getBudgetId() == null)
            return false;
        if (other.getBudgetId() != null && other.getBudgetId().equals(this.getBudgetId()) == false)
            return false;
        if (other.getFarmId() == null ^ this.getFarmId() == null)
            return false;
        if (other.getFarmId() != null && other.getFarmId().equals(this.getFarmId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBudgetId() == null) ? 0 : getBudgetId().hashCode());
        hashCode = prime * hashCode + ((getFarmId() == null) ? 0 : getFarmId().hashCode());
        return hashCode;
    }

    @Override
    public DeleteBudgetRequest clone() {
        return (DeleteBudgetRequest) super.clone();
    }

}
