/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datasync.model.Throughput;

@SdkInternalApi
public class ThroughputMarshaller {
    private static final MarshallingInfo<Double> READ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Read").build();
    private static final MarshallingInfo<Double> WRITE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Write").build();
    private static final MarshallingInfo<Double> OTHER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Other").build();
    private static final MarshallingInfo<Double> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Total").build();
    private static final ThroughputMarshaller instance = new ThroughputMarshaller();

    public static ThroughputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Throughput throughput, ProtocolMarshaller protocolMarshaller) {
        if (throughput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)throughput.getRead(), READ_BINDING);
            protocolMarshaller.marshall((Object)throughput.getWrite(), WRITE_BINDING);
            protocolMarshaller.marshall((Object)throughput.getOther(), OTHER_BINDING);
            protocolMarshaller.marshall((Object)throughput.getTotal(), TOTAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

