/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeObjectsRequestMarshaller
implements Marshaller<Request<DescribeObjectsRequest>, DescribeObjectsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeObjectsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeObjectsRequest> marshall(DescribeObjectsRequest describeObjectsRequest) {
        if (describeObjectsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeObjectsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.DescribeObjects");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList objectIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeObjectsRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(describeObjectsRequest.getPipelineId());
            }
            if (!(objectIdsList = (SdkInternalList)describeObjectsRequest.getObjectIds()).isEmpty() || !objectIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("objectIds");
                jsonGenerator.writeStartArray();
                for (String objectIdsListValue : objectIdsList) {
                    if (objectIdsListValue == null) continue;
                    jsonGenerator.writeValue(objectIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeObjectsRequest.getEvaluateExpressions() != null) {
                jsonGenerator.writeFieldName("evaluateExpressions").writeValue(describeObjectsRequest.getEvaluateExpressions().booleanValue());
            }
            if (describeObjectsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("marker").writeValue(describeObjectsRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

