/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationsResult
implements Serializable {
    private ListWithAutoConstructFlag<String> applications;
    private String nextToken;

    public List<String> getApplications() {
        if (this.applications == null) {
            this.applications = new ListWithAutoConstructFlag();
            this.applications.setAutoConstruct(true);
        }
        return this.applications;
    }

    public void setApplications(Collection<String> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        ListWithAutoConstructFlag applicationsCopy = new ListWithAutoConstructFlag(applications.size());
        applicationsCopy.addAll(applications);
        this.applications = applicationsCopy;
    }

    public ListApplicationsResult withApplications(String ... applications) {
        if (this.getApplications() == null) {
            this.setApplications(new ArrayList<String>(applications.length));
        }
        for (String value : applications) {
            this.getApplications().add(value);
        }
        return this;
    }

    public ListApplicationsResult withApplications(Collection<String> applications) {
        if (applications == null) {
            this.applications = null;
        } else {
            ListWithAutoConstructFlag applicationsCopy = new ListWithAutoConstructFlag(applications.size());
            applicationsCopy.addAll(applications);
            this.applications = applicationsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListApplicationsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplications() != null) {
            sb.append("Applications: " + this.getApplications() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResult)) {
            return false;
        }
        ListApplicationsResult other = (ListApplicationsResult)obj;
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        if (other.getApplications() != null && !other.getApplications().equals(this.getApplications())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

