/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codecommit.AWSCodeCommitAsync;
import com.amazonaws.services.codecommit.AWSCodeCommitClient;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesResult;
import com.amazonaws.services.codecommit.model.CreateBranchRequest;
import com.amazonaws.services.codecommit.model.CreateBranchResult;
import com.amazonaws.services.codecommit.model.CreateRepositoryRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryResult;
import com.amazonaws.services.codecommit.model.DeleteRepositoryRequest;
import com.amazonaws.services.codecommit.model.DeleteRepositoryResult;
import com.amazonaws.services.codecommit.model.GetBranchRequest;
import com.amazonaws.services.codecommit.model.GetBranchResult;
import com.amazonaws.services.codecommit.model.GetCommitRequest;
import com.amazonaws.services.codecommit.model.GetCommitResult;
import com.amazonaws.services.codecommit.model.GetRepositoryRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryResult;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.ListBranchesRequest;
import com.amazonaws.services.codecommit.model.ListBranchesResult;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.services.codecommit.model.ListRepositoriesResult;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchRequest;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchResult;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionResult;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeCommitAsyncClient
extends AWSCodeCommitClient
implements AWSCodeCommitAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCodeCommitAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSCodeCommitAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCodeCommitAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetRepositoriesResult> batchGetRepositoriesAsync(BatchGetRepositoriesRequest request) {
        return this.batchGetRepositoriesAsync(request, null);
    }

    @Override
    public Future<BatchGetRepositoriesResult> batchGetRepositoriesAsync(final BatchGetRepositoriesRequest request, final AsyncHandler<BatchGetRepositoriesRequest, BatchGetRepositoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetRepositoriesResult>(){

            @Override
            public BatchGetRepositoriesResult call() throws Exception {
                BatchGetRepositoriesResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.batchGetRepositories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBranchResult> createBranchAsync(CreateBranchRequest request) {
        return this.createBranchAsync(request, null);
    }

    @Override
    public Future<CreateBranchResult> createBranchAsync(final CreateBranchRequest request, final AsyncHandler<CreateBranchRequest, CreateBranchResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateBranchResult>(){

            @Override
            public CreateBranchResult call() throws Exception {
                CreateBranchResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.createBranch(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryAsync(request, null);
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(final CreateRepositoryRequest request, final AsyncHandler<CreateRepositoryRequest, CreateRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() throws Exception {
                CreateRepositoryResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.createRepository(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(final DeleteRepositoryRequest request, final AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() throws Exception {
                DeleteRepositoryResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.deleteRepository(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBranchResult> getBranchAsync(GetBranchRequest request) {
        return this.getBranchAsync(request, null);
    }

    @Override
    public Future<GetBranchResult> getBranchAsync(final GetBranchRequest request, final AsyncHandler<GetBranchRequest, GetBranchResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetBranchResult>(){

            @Override
            public GetBranchResult call() throws Exception {
                GetBranchResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.getBranch(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCommitResult> getCommitAsync(GetCommitRequest request) {
        return this.getCommitAsync(request, null);
    }

    @Override
    public Future<GetCommitResult> getCommitAsync(final GetCommitRequest request, final AsyncHandler<GetCommitRequest, GetCommitResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCommitResult>(){

            @Override
            public GetCommitResult call() throws Exception {
                GetCommitResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.getCommit(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryResult> getRepositoryAsync(GetRepositoryRequest request) {
        return this.getRepositoryAsync(request, null);
    }

    @Override
    public Future<GetRepositoryResult> getRepositoryAsync(final GetRepositoryRequest request, final AsyncHandler<GetRepositoryRequest, GetRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRepositoryResult>(){

            @Override
            public GetRepositoryResult call() throws Exception {
                GetRepositoryResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.getRepository(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryTriggersResult> getRepositoryTriggersAsync(GetRepositoryTriggersRequest request) {
        return this.getRepositoryTriggersAsync(request, null);
    }

    @Override
    public Future<GetRepositoryTriggersResult> getRepositoryTriggersAsync(final GetRepositoryTriggersRequest request, final AsyncHandler<GetRepositoryTriggersRequest, GetRepositoryTriggersResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRepositoryTriggersResult>(){

            @Override
            public GetRepositoryTriggersResult call() throws Exception {
                GetRepositoryTriggersResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.getRepositoryTriggers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBranchesResult> listBranchesAsync(ListBranchesRequest request) {
        return this.listBranchesAsync(request, null);
    }

    @Override
    public Future<ListBranchesResult> listBranchesAsync(final ListBranchesRequest request, final AsyncHandler<ListBranchesRequest, ListBranchesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBranchesResult>(){

            @Override
            public ListBranchesResult call() throws Exception {
                ListBranchesResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.listBranches(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositoriesResult> listRepositoriesAsync(ListRepositoriesRequest request) {
        return this.listRepositoriesAsync(request, null);
    }

    @Override
    public Future<ListRepositoriesResult> listRepositoriesAsync(final ListRepositoriesRequest request, final AsyncHandler<ListRepositoriesRequest, ListRepositoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRepositoriesResult>(){

            @Override
            public ListRepositoriesResult call() throws Exception {
                ListRepositoriesResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.listRepositories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRepositoryTriggersResult> putRepositoryTriggersAsync(PutRepositoryTriggersRequest request) {
        return this.putRepositoryTriggersAsync(request, null);
    }

    @Override
    public Future<PutRepositoryTriggersResult> putRepositoryTriggersAsync(final PutRepositoryTriggersRequest request, final AsyncHandler<PutRepositoryTriggersRequest, PutRepositoryTriggersResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRepositoryTriggersResult>(){

            @Override
            public PutRepositoryTriggersResult call() throws Exception {
                PutRepositoryTriggersResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.putRepositoryTriggers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestRepositoryTriggersResult> testRepositoryTriggersAsync(TestRepositoryTriggersRequest request) {
        return this.testRepositoryTriggersAsync(request, null);
    }

    @Override
    public Future<TestRepositoryTriggersResult> testRepositoryTriggersAsync(final TestRepositoryTriggersRequest request, final AsyncHandler<TestRepositoryTriggersRequest, TestRepositoryTriggersResult> asyncHandler) {
        return this.executorService.submit(new Callable<TestRepositoryTriggersResult>(){

            @Override
            public TestRepositoryTriggersResult call() throws Exception {
                TestRepositoryTriggersResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.testRepositoryTriggers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDefaultBranchResult> updateDefaultBranchAsync(UpdateDefaultBranchRequest request) {
        return this.updateDefaultBranchAsync(request, null);
    }

    @Override
    public Future<UpdateDefaultBranchResult> updateDefaultBranchAsync(final UpdateDefaultBranchRequest request, final AsyncHandler<UpdateDefaultBranchRequest, UpdateDefaultBranchResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDefaultBranchResult>(){

            @Override
            public UpdateDefaultBranchResult call() throws Exception {
                UpdateDefaultBranchResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.updateDefaultBranch(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRepositoryDescriptionResult> updateRepositoryDescriptionAsync(UpdateRepositoryDescriptionRequest request) {
        return this.updateRepositoryDescriptionAsync(request, null);
    }

    @Override
    public Future<UpdateRepositoryDescriptionResult> updateRepositoryDescriptionAsync(final UpdateRepositoryDescriptionRequest request, final AsyncHandler<UpdateRepositoryDescriptionRequest, UpdateRepositoryDescriptionResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateRepositoryDescriptionResult>(){

            @Override
            public UpdateRepositoryDescriptionResult call() throws Exception {
                UpdateRepositoryDescriptionResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.updateRepositoryDescription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRepositoryNameResult> updateRepositoryNameAsync(UpdateRepositoryNameRequest request) {
        return this.updateRepositoryNameAsync(request, null);
    }

    @Override
    public Future<UpdateRepositoryNameResult> updateRepositoryNameAsync(final UpdateRepositoryNameRequest request, final AsyncHandler<UpdateRepositoryNameRequest, UpdateRepositoryNameResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateRepositoryNameResult>(){

            @Override
            public UpdateRepositoryNameResult call() throws Exception {
                UpdateRepositoryNameResult result;
                try {
                    result = AWSCodeCommitAsyncClient.this.updateRepositoryName(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

