/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.S3ImportSource;

@SdkInternalApi
public class S3ImportSourceMarshaller {
    private static final MarshallingInfo<String> S3LOCATIONURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3LocationUri").build();
    private static final MarshallingInfo<String> S3BUCKETREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketRegion").build();
    private static final MarshallingInfo<String> S3BUCKETACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketAccessRoleArn").build();
    private static final S3ImportSourceMarshaller instance = new S3ImportSourceMarshaller();

    public static S3ImportSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ImportSource s3ImportSource, ProtocolMarshaller protocolMarshaller) {
        if (s3ImportSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ImportSource.getS3LocationUri(), S3LOCATIONURI_BINDING);
            protocolMarshaller.marshall((Object)s3ImportSource.getS3BucketRegion(), S3BUCKETREGION_BINDING);
            protocolMarshaller.marshall((Object)s3ImportSource.getS3BucketAccessRoleArn(), S3BUCKETACCESSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

