/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.CreateBudgetRequest;
import com.amazonaws.services.budgets.model.NotificationWithSubscribers;
import com.amazonaws.services.budgets.model.transform.BudgetJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.NotificationWithSubscribersJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateBudgetRequestMarshaller
implements Marshaller<Request<CreateBudgetRequest>, CreateBudgetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateBudgetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateBudgetRequest> marshall(CreateBudgetRequest createBudgetRequest) {
        if (createBudgetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createBudgetRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.CreateBudget");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<NotificationWithSubscribers> notificationsWithSubscribersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createBudgetRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(createBudgetRequest.getAccountId());
            }
            if (createBudgetRequest.getBudget() != null) {
                jsonGenerator.writeFieldName("Budget");
                BudgetJsonMarshaller.getInstance().marshall(createBudgetRequest.getBudget(), jsonGenerator);
            }
            if ((notificationsWithSubscribersList = createBudgetRequest.getNotificationsWithSubscribers()) != null) {
                jsonGenerator.writeFieldName("NotificationsWithSubscribers");
                jsonGenerator.writeStartArray();
                for (NotificationWithSubscribers notificationsWithSubscribersListValue : notificationsWithSubscribersList) {
                    if (notificationsWithSubscribersListValue == null) continue;
                    NotificationWithSubscribersJsonMarshaller.getInstance().marshall(notificationsWithSubscribersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

