/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockruntime.model.Message;
import java.util.List;

@SdkInternalApi
public class MessageMarshaller {
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("role").build();
    private static final MarshallingInfo<List> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("content").build();
    private static final MessageMarshaller instance = new MessageMarshaller();

    public static MessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Message message, ProtocolMarshaller protocolMarshaller) {
        if (message == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)message.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall(message.getContent(), CONTENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

