/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.CustomizedMetricSpecification;
import com.amazonaws.services.autoscaling.model.Metric;
import com.amazonaws.services.autoscaling.model.MetricDataQuery;
import com.amazonaws.services.autoscaling.model.MetricDimension;
import com.amazonaws.services.autoscaling.model.MetricStat;
import com.amazonaws.services.autoscaling.model.PredefinedMetricSpecification;
import com.amazonaws.services.autoscaling.model.PredictiveScalingConfiguration;
import com.amazonaws.services.autoscaling.model.PredictiveScalingCustomizedCapacityMetric;
import com.amazonaws.services.autoscaling.model.PredictiveScalingCustomizedLoadMetric;
import com.amazonaws.services.autoscaling.model.PredictiveScalingCustomizedScalingMetric;
import com.amazonaws.services.autoscaling.model.PredictiveScalingMetricSpecification;
import com.amazonaws.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric;
import com.amazonaws.services.autoscaling.model.PredictiveScalingPredefinedMetricPair;
import com.amazonaws.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.TargetTrackingConfiguration;
import com.amazonaws.services.autoscaling.model.TargetTrackingMetricDataQuery;
import com.amazonaws.services.autoscaling.model.TargetTrackingMetricStat;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutScalingPolicyRequestMarshaller
implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {
    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {
        PredictiveScalingConfiguration predictiveScalingConfiguration;
        TargetTrackingConfiguration targetTrackingConfiguration;
        if (putScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScalingPolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScalingPolicyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putScalingPolicyRequest.getAutoScalingGroupName()));
        }
        if (putScalingPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putScalingPolicyRequest.getPolicyName()));
        }
        if (putScalingPolicyRequest.getPolicyType() != null) {
            request.addParameter("PolicyType", StringUtils.fromString((String)putScalingPolicyRequest.getPolicyType()));
        }
        if (putScalingPolicyRequest.getAdjustmentType() != null) {
            request.addParameter("AdjustmentType", StringUtils.fromString((String)putScalingPolicyRequest.getAdjustmentType()));
        }
        if (putScalingPolicyRequest.getMinAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getMinAdjustmentStep()));
        }
        if (putScalingPolicyRequest.getMinAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getMinAdjustmentMagnitude()));
        }
        if (putScalingPolicyRequest.getScalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getScalingAdjustment()));
        }
        if (putScalingPolicyRequest.getCooldown() != null) {
            request.addParameter("Cooldown", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getCooldown()));
        }
        if (putScalingPolicyRequest.getMetricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringUtils.fromString((String)putScalingPolicyRequest.getMetricAggregationType()));
        }
        if (!putScalingPolicyRequest.getStepAdjustments().isEmpty() || !((SdkInternalList)putScalingPolicyRequest.getStepAdjustments()).isAutoConstruct()) {
            SdkInternalList stepAdjustmentsList = (SdkInternalList)putScalingPolicyRequest.getStepAdjustments();
            int stepAdjustmentsListIndex = 1;
            for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {
                if (stepAdjustmentsListValue != null) {
                    if (stepAdjustmentsListValue.getMetricIntervalLowerBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.getMetricIntervalLowerBound()));
                    }
                    if (stepAdjustmentsListValue.getMetricIntervalUpperBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.getMetricIntervalUpperBound()));
                    }
                    if (stepAdjustmentsListValue.getScalingAdjustment() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment", StringUtils.fromInteger((Integer)stepAdjustmentsListValue.getScalingAdjustment()));
                    }
                }
                ++stepAdjustmentsListIndex;
            }
        }
        if (putScalingPolicyRequest.getEstimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getEstimatedInstanceWarmup()));
        }
        if ((targetTrackingConfiguration = putScalingPolicyRequest.getTargetTrackingConfiguration()) != null) {
            CustomizedMetricSpecification customizedMetricSpecification;
            PredefinedMetricSpecification predefinedMetricSpecification = targetTrackingConfiguration.getPredefinedMetricSpecification();
            if (predefinedMetricSpecification != null) {
                if (predefinedMetricSpecification.getPredefinedMetricType() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.PredefinedMetricType", StringUtils.fromString((String)predefinedMetricSpecification.getPredefinedMetricType()));
                }
                if (predefinedMetricSpecification.getResourceLabel() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.ResourceLabel", StringUtils.fromString((String)predefinedMetricSpecification.getResourceLabel()));
                }
            }
            if ((customizedMetricSpecification = targetTrackingConfiguration.getCustomizedMetricSpecification()) != null) {
                if (customizedMetricSpecification.getMetricName() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.MetricName", StringUtils.fromString((String)customizedMetricSpecification.getMetricName()));
                }
                if (customizedMetricSpecification.getNamespace() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Namespace", StringUtils.fromString((String)customizedMetricSpecification.getNamespace()));
                }
                if (!customizedMetricSpecification.getDimensions().isEmpty() || !((SdkInternalList)customizedMetricSpecification.getDimensions()).isAutoConstruct()) {
                    SdkInternalList dimensionsList = (SdkInternalList)customizedMetricSpecification.getDimensions();
                    int dimensionsListIndex = 1;
                    for (MetricDimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue != null) {
                            if (dimensionsListValue.getName() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                            }
                            if (dimensionsListValue.getValue() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                            }
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (customizedMetricSpecification.getStatistic() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Statistic", StringUtils.fromString((String)customizedMetricSpecification.getStatistic()));
                }
                if (customizedMetricSpecification.getUnit() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Unit", StringUtils.fromString((String)customizedMetricSpecification.getUnit()));
                }
                if (!customizedMetricSpecification.getMetrics().isEmpty() || !((SdkInternalList)customizedMetricSpecification.getMetrics()).isAutoConstruct()) {
                    SdkInternalList metricsList = (SdkInternalList)customizedMetricSpecification.getMetrics();
                    int metricsListIndex = 1;
                    for (TargetTrackingMetricDataQuery metricsListValue : metricsList) {
                        if (metricsListValue != null) {
                            TargetTrackingMetricStat metricStat;
                            if (metricsListValue.getId() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".Id", StringUtils.fromString((String)metricsListValue.getId()));
                            }
                            if (metricsListValue.getExpression() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".Expression", StringUtils.fromString((String)metricsListValue.getExpression()));
                            }
                            if ((metricStat = metricsListValue.getMetricStat()) != null) {
                                Metric metric = metricStat.getMetric();
                                if (metric != null) {
                                    if (metric.getNamespace() != null) {
                                        request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                                    }
                                    if (metric.getMetricName() != null) {
                                        request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                                    }
                                    if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                        SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                                        int dimensionsListIndex = 1;
                                        for (MetricDimension dimensionsListValue : dimensionsList) {
                                            if (dimensionsListValue != null) {
                                                if (dimensionsListValue.getName() != null) {
                                                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                                }
                                                if (dimensionsListValue.getValue() != null) {
                                                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                                }
                                            }
                                            ++dimensionsListIndex;
                                        }
                                    }
                                }
                                if (metricStat.getStat() != null) {
                                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                                }
                                if (metricStat.getUnit() != null) {
                                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                                }
                            }
                            if (metricsListValue.getLabel() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".Label", StringUtils.fromString((String)metricsListValue.getLabel()));
                            }
                            if (metricsListValue.getReturnData() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Metrics.member." + metricsListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricsListValue.getReturnData()));
                            }
                        }
                        ++metricsListIndex;
                    }
                }
            }
            if (targetTrackingConfiguration.getTargetValue() != null) {
                request.addParameter("TargetTrackingConfiguration.TargetValue", StringUtils.fromDouble((Double)targetTrackingConfiguration.getTargetValue()));
            }
            if (targetTrackingConfiguration.getDisableScaleIn() != null) {
                request.addParameter("TargetTrackingConfiguration.DisableScaleIn", StringUtils.fromBoolean((Boolean)targetTrackingConfiguration.getDisableScaleIn()));
            }
        }
        if (putScalingPolicyRequest.getEnabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)putScalingPolicyRequest.getEnabled()));
        }
        if ((predictiveScalingConfiguration = putScalingPolicyRequest.getPredictiveScalingConfiguration()) != null) {
            if (!predictiveScalingConfiguration.getMetricSpecifications().isEmpty() || !((SdkInternalList)predictiveScalingConfiguration.getMetricSpecifications()).isAutoConstruct()) {
                SdkInternalList metricSpecificationsList = (SdkInternalList)predictiveScalingConfiguration.getMetricSpecifications();
                int metricSpecificationsListIndex = 1;
                for (PredictiveScalingMetricSpecification metricSpecificationsListValue : metricSpecificationsList) {
                    if (metricSpecificationsListValue != null) {
                        PredictiveScalingCustomizedCapacityMetric customizedCapacityMetricSpecification;
                        PredictiveScalingCustomizedLoadMetric customizedLoadMetricSpecification;
                        int dimensionsListIndex;
                        SdkInternalList dimensionsList;
                        Metric metric;
                        MetricStat metricStat;
                        int metricDataQueriesListIndex;
                        SdkInternalList metricDataQueriesList;
                        PredictiveScalingCustomizedScalingMetric customizedScalingMetricSpecification;
                        PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification;
                        PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification;
                        PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification;
                        if (metricSpecificationsListValue.getTargetValue() != null) {
                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".TargetValue", StringUtils.fromDouble((Double)metricSpecificationsListValue.getTargetValue()));
                        }
                        if ((predefinedMetricPairSpecification = metricSpecificationsListValue.getPredefinedMetricPairSpecification()) != null) {
                            if (predefinedMetricPairSpecification.getPredefinedMetricType() != null) {
                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".PredefinedMetricPairSpecification.PredefinedMetricType", StringUtils.fromString((String)predefinedMetricPairSpecification.getPredefinedMetricType()));
                            }
                            if (predefinedMetricPairSpecification.getResourceLabel() != null) {
                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".PredefinedMetricPairSpecification.ResourceLabel", StringUtils.fromString((String)predefinedMetricPairSpecification.getResourceLabel()));
                            }
                        }
                        if ((predefinedScalingMetricSpecification = metricSpecificationsListValue.getPredefinedScalingMetricSpecification()) != null) {
                            if (predefinedScalingMetricSpecification.getPredefinedMetricType() != null) {
                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".PredefinedScalingMetricSpecification.PredefinedMetricType", StringUtils.fromString((String)predefinedScalingMetricSpecification.getPredefinedMetricType()));
                            }
                            if (predefinedScalingMetricSpecification.getResourceLabel() != null) {
                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".PredefinedScalingMetricSpecification.ResourceLabel", StringUtils.fromString((String)predefinedScalingMetricSpecification.getResourceLabel()));
                            }
                        }
                        if ((predefinedLoadMetricSpecification = metricSpecificationsListValue.getPredefinedLoadMetricSpecification()) != null) {
                            if (predefinedLoadMetricSpecification.getPredefinedMetricType() != null) {
                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".PredefinedLoadMetricSpecification.PredefinedMetricType", StringUtils.fromString((String)predefinedLoadMetricSpecification.getPredefinedMetricType()));
                            }
                            if (predefinedLoadMetricSpecification.getResourceLabel() != null) {
                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".PredefinedLoadMetricSpecification.ResourceLabel", StringUtils.fromString((String)predefinedLoadMetricSpecification.getResourceLabel()));
                            }
                        }
                        if (!((customizedScalingMetricSpecification = metricSpecificationsListValue.getCustomizedScalingMetricSpecification()) == null || customizedScalingMetricSpecification.getMetricDataQueries().isEmpty() && ((SdkInternalList)customizedScalingMetricSpecification.getMetricDataQueries()).isAutoConstruct())) {
                            metricDataQueriesList = (SdkInternalList)customizedScalingMetricSpecification.getMetricDataQueries();
                            metricDataQueriesListIndex = 1;
                            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                                if (metricDataQueriesListValue != null) {
                                    if (metricDataQueriesListValue.getId() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString((String)metricDataQueriesListValue.getId()));
                                    }
                                    if (metricDataQueriesListValue.getExpression() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString((String)metricDataQueriesListValue.getExpression()));
                                    }
                                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                                        metric = metricStat.getMetric();
                                        if (metric != null) {
                                            if (metric.getNamespace() != null) {
                                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                                            }
                                            if (metric.getMetricName() != null) {
                                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                                            }
                                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                                dimensionsList = (SdkInternalList)metric.getDimensions();
                                                dimensionsListIndex = 1;
                                                for (MetricDimension dimensionsListValue : dimensionsList) {
                                                    if (dimensionsListValue != null) {
                                                        if (dimensionsListValue.getName() != null) {
                                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                                        }
                                                        if (dimensionsListValue.getValue() != null) {
                                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                                        }
                                                    }
                                                    ++dimensionsListIndex;
                                                }
                                            }
                                        }
                                        if (metricStat.getStat() != null) {
                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                                        }
                                        if (metricStat.getUnit() != null) {
                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                                        }
                                    }
                                    if (metricDataQueriesListValue.getLabel() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString((String)metricDataQueriesListValue.getLabel()));
                                    }
                                    if (metricDataQueriesListValue.getReturnData() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedScalingMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricDataQueriesListValue.getReturnData()));
                                    }
                                }
                                ++metricDataQueriesListIndex;
                            }
                        }
                        if (!((customizedLoadMetricSpecification = metricSpecificationsListValue.getCustomizedLoadMetricSpecification()) == null || customizedLoadMetricSpecification.getMetricDataQueries().isEmpty() && ((SdkInternalList)customizedLoadMetricSpecification.getMetricDataQueries()).isAutoConstruct())) {
                            metricDataQueriesList = (SdkInternalList)customizedLoadMetricSpecification.getMetricDataQueries();
                            metricDataQueriesListIndex = 1;
                            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                                if (metricDataQueriesListValue != null) {
                                    if (metricDataQueriesListValue.getId() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString((String)metricDataQueriesListValue.getId()));
                                    }
                                    if (metricDataQueriesListValue.getExpression() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString((String)metricDataQueriesListValue.getExpression()));
                                    }
                                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                                        metric = metricStat.getMetric();
                                        if (metric != null) {
                                            if (metric.getNamespace() != null) {
                                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                                            }
                                            if (metric.getMetricName() != null) {
                                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                                            }
                                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                                dimensionsList = (SdkInternalList)metric.getDimensions();
                                                dimensionsListIndex = 1;
                                                for (MetricDimension dimensionsListValue : dimensionsList) {
                                                    if (dimensionsListValue != null) {
                                                        if (dimensionsListValue.getName() != null) {
                                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                                        }
                                                        if (dimensionsListValue.getValue() != null) {
                                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                                        }
                                                    }
                                                    ++dimensionsListIndex;
                                                }
                                            }
                                        }
                                        if (metricStat.getStat() != null) {
                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                                        }
                                        if (metricStat.getUnit() != null) {
                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                                        }
                                    }
                                    if (metricDataQueriesListValue.getLabel() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString((String)metricDataQueriesListValue.getLabel()));
                                    }
                                    if (metricDataQueriesListValue.getReturnData() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedLoadMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricDataQueriesListValue.getReturnData()));
                                    }
                                }
                                ++metricDataQueriesListIndex;
                            }
                        }
                        if (!((customizedCapacityMetricSpecification = metricSpecificationsListValue.getCustomizedCapacityMetricSpecification()) == null || customizedCapacityMetricSpecification.getMetricDataQueries().isEmpty() && ((SdkInternalList)customizedCapacityMetricSpecification.getMetricDataQueries()).isAutoConstruct())) {
                            metricDataQueriesList = (SdkInternalList)customizedCapacityMetricSpecification.getMetricDataQueries();
                            metricDataQueriesListIndex = 1;
                            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                                if (metricDataQueriesListValue != null) {
                                    if (metricDataQueriesListValue.getId() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString((String)metricDataQueriesListValue.getId()));
                                    }
                                    if (metricDataQueriesListValue.getExpression() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString((String)metricDataQueriesListValue.getExpression()));
                                    }
                                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                                        metric = metricStat.getMetric();
                                        if (metric != null) {
                                            if (metric.getNamespace() != null) {
                                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                                            }
                                            if (metric.getMetricName() != null) {
                                                request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                                            }
                                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                                dimensionsList = (SdkInternalList)metric.getDimensions();
                                                dimensionsListIndex = 1;
                                                for (MetricDimension dimensionsListValue : dimensionsList) {
                                                    if (dimensionsListValue != null) {
                                                        if (dimensionsListValue.getName() != null) {
                                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                                        }
                                                        if (dimensionsListValue.getValue() != null) {
                                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                                        }
                                                    }
                                                    ++dimensionsListIndex;
                                                }
                                            }
                                        }
                                        if (metricStat.getStat() != null) {
                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                                        }
                                        if (metricStat.getUnit() != null) {
                                            request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                                        }
                                    }
                                    if (metricDataQueriesListValue.getLabel() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString((String)metricDataQueriesListValue.getLabel()));
                                    }
                                    if (metricDataQueriesListValue.getReturnData() != null) {
                                        request.addParameter("PredictiveScalingConfiguration.MetricSpecifications.member." + metricSpecificationsListIndex + ".CustomizedCapacityMetricSpecification.MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricDataQueriesListValue.getReturnData()));
                                    }
                                }
                                ++metricDataQueriesListIndex;
                            }
                        }
                    }
                    ++metricSpecificationsListIndex;
                }
            }
            if (predictiveScalingConfiguration.getMode() != null) {
                request.addParameter("PredictiveScalingConfiguration.Mode", StringUtils.fromString((String)predictiveScalingConfiguration.getMode()));
            }
            if (predictiveScalingConfiguration.getSchedulingBufferTime() != null) {
                request.addParameter("PredictiveScalingConfiguration.SchedulingBufferTime", StringUtils.fromInteger((Integer)predictiveScalingConfiguration.getSchedulingBufferTime()));
            }
            if (predictiveScalingConfiguration.getMaxCapacityBreachBehavior() != null) {
                request.addParameter("PredictiveScalingConfiguration.MaxCapacityBreachBehavior", StringUtils.fromString((String)predictiveScalingConfiguration.getMaxCapacityBreachBehavior()));
            }
            if (predictiveScalingConfiguration.getMaxCapacityBuffer() != null) {
                request.addParameter("PredictiveScalingConfiguration.MaxCapacityBuffer", StringUtils.fromInteger((Integer)predictiveScalingConfiguration.getMaxCapacityBuffer()));
            }
        }
        return request;
    }
}

