/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.athena.model.QueryExecutionContext;
import com.amazonaws.services.athena.model.ResultConfiguration;
import com.amazonaws.services.athena.model.ResultReuseConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartQueryExecutionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queryString;
    private String clientRequestToken;
    private QueryExecutionContext queryExecutionContext;
    private ResultConfiguration resultConfiguration;
    private String workGroup;
    private List<String> executionParameters;
    private ResultReuseConfiguration resultReuseConfiguration;

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public StartQueryExecutionRequest withQueryString(String queryString) {
        this.setQueryString(queryString);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartQueryExecutionRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setQueryExecutionContext(QueryExecutionContext queryExecutionContext) {
        this.queryExecutionContext = queryExecutionContext;
    }

    public QueryExecutionContext getQueryExecutionContext() {
        return this.queryExecutionContext;
    }

    public StartQueryExecutionRequest withQueryExecutionContext(QueryExecutionContext queryExecutionContext) {
        this.setQueryExecutionContext(queryExecutionContext);
        return this;
    }

    public void setResultConfiguration(ResultConfiguration resultConfiguration) {
        this.resultConfiguration = resultConfiguration;
    }

    public ResultConfiguration getResultConfiguration() {
        return this.resultConfiguration;
    }

    public StartQueryExecutionRequest withResultConfiguration(ResultConfiguration resultConfiguration) {
        this.setResultConfiguration(resultConfiguration);
        return this;
    }

    public void setWorkGroup(String workGroup) {
        this.workGroup = workGroup;
    }

    public String getWorkGroup() {
        return this.workGroup;
    }

    public StartQueryExecutionRequest withWorkGroup(String workGroup) {
        this.setWorkGroup(workGroup);
        return this;
    }

    public List<String> getExecutionParameters() {
        return this.executionParameters;
    }

    public void setExecutionParameters(Collection<String> executionParameters) {
        if (executionParameters == null) {
            this.executionParameters = null;
            return;
        }
        this.executionParameters = new ArrayList<String>(executionParameters);
    }

    public StartQueryExecutionRequest withExecutionParameters(String ... executionParameters) {
        if (this.executionParameters == null) {
            this.setExecutionParameters(new ArrayList<String>(executionParameters.length));
        }
        for (String ele : executionParameters) {
            this.executionParameters.add(ele);
        }
        return this;
    }

    public StartQueryExecutionRequest withExecutionParameters(Collection<String> executionParameters) {
        this.setExecutionParameters(executionParameters);
        return this;
    }

    public void setResultReuseConfiguration(ResultReuseConfiguration resultReuseConfiguration) {
        this.resultReuseConfiguration = resultReuseConfiguration;
    }

    public ResultReuseConfiguration getResultReuseConfiguration() {
        return this.resultReuseConfiguration;
    }

    public StartQueryExecutionRequest withResultReuseConfiguration(ResultReuseConfiguration resultReuseConfiguration) {
        this.setResultReuseConfiguration(resultReuseConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryString() != null) {
            sb.append("QueryString: ").append(this.getQueryString()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getQueryExecutionContext() != null) {
            sb.append("QueryExecutionContext: ").append(this.getQueryExecutionContext()).append(",");
        }
        if (this.getResultConfiguration() != null) {
            sb.append("ResultConfiguration: ").append(this.getResultConfiguration()).append(",");
        }
        if (this.getWorkGroup() != null) {
            sb.append("WorkGroup: ").append(this.getWorkGroup()).append(",");
        }
        if (this.getExecutionParameters() != null) {
            sb.append("ExecutionParameters: ").append(this.getExecutionParameters()).append(",");
        }
        if (this.getResultReuseConfiguration() != null) {
            sb.append("ResultReuseConfiguration: ").append(this.getResultReuseConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryExecutionRequest)) {
            return false;
        }
        StartQueryExecutionRequest other = (StartQueryExecutionRequest)obj;
        if (other.getQueryString() == null ^ this.getQueryString() == null) {
            return false;
        }
        if (other.getQueryString() != null && !other.getQueryString().equals(this.getQueryString())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getQueryExecutionContext() == null ^ this.getQueryExecutionContext() == null) {
            return false;
        }
        if (other.getQueryExecutionContext() != null && !other.getQueryExecutionContext().equals(this.getQueryExecutionContext())) {
            return false;
        }
        if (other.getResultConfiguration() == null ^ this.getResultConfiguration() == null) {
            return false;
        }
        if (other.getResultConfiguration() != null && !other.getResultConfiguration().equals(this.getResultConfiguration())) {
            return false;
        }
        if (other.getWorkGroup() == null ^ this.getWorkGroup() == null) {
            return false;
        }
        if (other.getWorkGroup() != null && !other.getWorkGroup().equals(this.getWorkGroup())) {
            return false;
        }
        if (other.getExecutionParameters() == null ^ this.getExecutionParameters() == null) {
            return false;
        }
        if (other.getExecutionParameters() != null && !other.getExecutionParameters().equals(this.getExecutionParameters())) {
            return false;
        }
        if (other.getResultReuseConfiguration() == null ^ this.getResultReuseConfiguration() == null) {
            return false;
        }
        return other.getResultReuseConfiguration() == null || other.getResultReuseConfiguration().equals(this.getResultReuseConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryString() == null ? 0 : this.getQueryString().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getQueryExecutionContext() == null ? 0 : this.getQueryExecutionContext().hashCode());
        hashCode = 31 * hashCode + (this.getResultConfiguration() == null ? 0 : this.getResultConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getWorkGroup() == null ? 0 : this.getWorkGroup().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionParameters() == null ? 0 : this.getExecutionParameters().hashCode());
        hashCode = 31 * hashCode + (this.getResultReuseConfiguration() == null ? 0 : this.getResultReuseConfiguration().hashCode());
        return hashCode;
    }

    public StartQueryExecutionRequest clone() {
        return (StartQueryExecutionRequest)super.clone();
    }
}

