/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.util.impl.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JacksonSerializer
implements Serializer {
    private static ObjectMapper mapper = ObjectMapperFactory.getMapper();

    static void setMapper(ObjectMapper objectMapper) {
        mapper = objectMapper;
    }

    public <T> String serialize(T t) {
        try {
            return mapper.writeValueAsString(t);
        }
        catch (IOException e) {
            throw new AskSdkException("Serialization error", (Throwable)e);
        }
    }

    public <T> void serialize(T object, OutputStream outputStream) {
        try {
            mapper.writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw new AskSdkException("Serialization error");
        }
    }

    public <T> T deserialize(String s, Class<T> aClass) {
        try {
            return (T)mapper.readValue(s, aClass);
        }
        catch (IOException e) {
            throw new AskSdkException("Deserialization error", (Throwable)e);
        }
    }

    public <T> T deserialize(InputStream inputStream, Class<T> type) {
        try {
            return (T)mapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new AskSdkException("Deserialization error", (Throwable)e);
        }
    }
}

