/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.intent;

import com.amazon.ask.model.ListSlotValue;
import com.amazon.ask.model.SimpleSlotValue;
import com.amazon.ask.model.SlotValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SlotValueWrapper {
    private SlotValue slotValue;

    private SlotValueWrapper(SlotValue slotValue) {
        this.slotValue = slotValue;
    }

    public static SlotValueWrapper createFrom(SlotValue slotValue) {
        return new SlotValueWrapper(slotValue);
    }

    public SlotValue unwrap() {
        return this.slotValue;
    }

    public List<SlotValueWrapper> values() {
        if (this.slotValue instanceof ListSlotValue) {
            return ((ListSlotValue)this.slotValue).getValues().stream().map(SlotValueWrapper::createFrom).collect(Collectors.toList());
        }
        return Collections.singletonList(this);
    }

    public Optional<SimpleSlotValue> asSimple() {
        return this.slotValue instanceof SimpleSlotValue ? Optional.of((SimpleSlotValue)this.slotValue) : Optional.empty();
    }

    public Optional<ListSlotValue> asList() {
        return this.slotValue instanceof ListSlotValue ? Optional.of((ListSlotValue)this.slotValue) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotValueWrapper that = (SlotValueWrapper)o;
        return Objects.equals(this.slotValue, that.slotValue);
    }

    public int hashCode() {
        return Objects.hash(this.slotValue);
    }
}

