/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request;

import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.model.DialogState;
import com.amazon.ask.model.IntentRequest;
import com.amazon.ask.model.Request;
import com.amazon.ask.model.Session;
import com.amazon.ask.model.Slot;
import com.amazon.ask.model.SupportedInterfaces;
import com.amazon.ask.model.User;
import com.amazon.ask.request.intent.SlotValueWrapper;
import com.amazon.ask.util.ValidationUtils;
import java.util.Map;
import java.util.Optional;

public final class RequestHelper {
    private final HandlerInput handlerInput;

    private RequestHelper(HandlerInput handlerInput) {
        this.handlerInput = (HandlerInput)((Object)ValidationUtils.assertNotNull((Object)((Object)handlerInput), (String)"handlerInput"));
    }

    public static RequestHelper forHandlerInput(HandlerInput input) {
        return new RequestHelper(input);
    }

    public String getLocale() {
        return ((Request)this.handlerInput.getRequest()).getLocale();
    }

    public String getRequestType() {
        return ((Request)this.handlerInput.getRequest()).getType();
    }

    public String getIntentName() {
        return RequestHelper.castRequestType(this.handlerInput, IntentRequest.class).getIntent().getName();
    }

    public String getAccountLinkingAccessToken() {
        return this.handlerInput.getRequestEnvelope().getContext().getSystem().getUser().getAccessToken();
    }

    public String getApiAccessToken() {
        return this.handlerInput.getRequestEnvelope().getContext().getSystem().getApiAccessToken();
    }

    public String getDeviceId() {
        return this.handlerInput.getRequestEnvelope().getContext().getSystem().getDevice().getDeviceId();
    }

    public DialogState getDialogState() {
        return RequestHelper.castRequestType(this.handlerInput, IntentRequest.class).getDialogState();
    }

    public Optional<Slot> getSlot(String slotName) {
        Map slots = RequestHelper.castRequestType(this.handlerInput, IntentRequest.class).getIntent().getSlots();
        if (slots != null) {
            return Optional.ofNullable(slots.get(slotName));
        }
        return Optional.empty();
    }

    public Optional<String> getSlotValue(String slotName) {
        return this.getSlot(slotName).map(Slot::getValue);
    }

    public SlotValueWrapper getSlotValueWrapper(String slotName) {
        return SlotValueWrapper.createFrom(this.getSlot(slotName).map(Slot::getSlotValue).orElse(null));
    }

    public SupportedInterfaces getSupportedInterfaces() {
        return this.handlerInput.getRequestEnvelope().getContext().getSystem().getDevice().getSupportedInterfaces();
    }

    public boolean isNewSession() {
        Session session = this.handlerInput.getRequestEnvelope().getSession();
        if (session == null) {
            throw new IllegalArgumentException("The provided request doesn't contain a session");
        }
        return session.getNew();
    }

    public Optional<String> getUserId() {
        return Optional.ofNullable(this.handlerInput.getRequestEnvelope().getContext().getSystem().getUser()).map(User::getUserId);
    }

    private static <T> T castRequestType(HandlerInput input, Class<T> targetType) {
        if (!targetType.isInstance(input.getRequest())) {
            throw new IllegalArgumentException("Provided request is not a " + targetType.getName());
        }
        return targetType.cast(input.getRequest());
    }
}

