/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.module;

import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.builder.SkillConfiguration;
import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.model.Response;
import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.request.exception.mapper.GenericExceptionMapper;
import com.amazon.ask.request.handler.adapter.GenericHandlerAdapter;
import com.amazon.ask.request.interceptor.GenericRequestInterceptor;
import com.amazon.ask.request.interceptor.GenericResponseInterceptor;
import com.amazon.ask.request.mapper.GenericRequestMapper;
import com.amazon.ask.response.template.TemplateFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SdkModuleContext {
    protected final SkillConfiguration.Builder skillConfigBuilder;

    public SdkModuleContext(SkillConfiguration.Builder skillConfigBuilder) {
        this.skillConfigBuilder = skillConfigBuilder;
    }

    public SdkModuleContext addRequestMappers(List<GenericRequestMapper<HandlerInput, Optional<Response>>> requestMapper) {
        requestMapper.forEach(arg_0 -> ((SkillConfiguration.Builder)this.skillConfigBuilder).addRequestMapper(arg_0));
        return this;
    }

    public SdkModuleContext addRequestMapper(GenericRequestMapper<HandlerInput, Optional<Response>> requestMapper) {
        this.skillConfigBuilder.addRequestMapper(requestMapper);
        return this;
    }

    public List<GenericRequestMapper<HandlerInput, Optional<Response>>> getRequestMappers() {
        return Collections.unmodifiableList(this.skillConfigBuilder.getRequestMappers());
    }

    public SdkModuleContext addHandlerAdapters(List<GenericHandlerAdapter<HandlerInput, Optional<Response>>> handlerAdapter) {
        handlerAdapter.forEach(arg_0 -> ((SkillConfiguration.Builder)this.skillConfigBuilder).addHandlerAdapter(arg_0));
        return this;
    }

    public SdkModuleContext addHandlerAdapter(GenericHandlerAdapter<HandlerInput, Optional<Response>> handlerAdapter) {
        this.skillConfigBuilder.addHandlerAdapter(handlerAdapter);
        return this;
    }

    public List<GenericHandlerAdapter<HandlerInput, Optional<Response>>> getHandlerAdapter() {
        return this.skillConfigBuilder.getHandlerAdapters() == null ? null : Collections.unmodifiableList(this.skillConfigBuilder.getHandlerAdapters());
    }

    public SdkModuleContext addRequestInterceptor(GenericRequestInterceptor<HandlerInput> requestInterceptor) {
        this.skillConfigBuilder.addRequestInterceptor(requestInterceptor);
        return this;
    }

    public List<GenericRequestInterceptor<HandlerInput>> getRequestInterceptors() {
        return this.skillConfigBuilder.getRequestInterceptors() == null ? null : Collections.unmodifiableList(this.skillConfigBuilder.getRequestInterceptors());
    }

    public SdkModuleContext addResponseInterceptor(GenericResponseInterceptor<HandlerInput, Optional<Response>> responseInterceptor) {
        this.skillConfigBuilder.addResponseInterceptor(responseInterceptor);
        return this;
    }

    public List<GenericResponseInterceptor<HandlerInput, Optional<Response>>> getResponseInterceptors() {
        return this.skillConfigBuilder.getResponseInterceptors() == null ? null : Collections.unmodifiableList(this.skillConfigBuilder.getResponseInterceptors());
    }

    public SdkModuleContext setExceptionMapper(GenericExceptionMapper<HandlerInput, Optional<Response>> exceptionMapper) {
        this.skillConfigBuilder.withExceptionMapper(exceptionMapper);
        return this;
    }

    public SdkModuleContext setPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        if (this.skillConfigBuilder.getPersistenceAdapter() != null) {
            throw new AskSdkException("Conflicting persistence adapter configuration: module attempting to override previously set value.");
        }
        this.skillConfigBuilder.withPersistenceAdapter(persistenceAdapter);
        return this;
    }

    public SdkModuleContext setApiClient(ApiClient apiClient) {
        if (this.skillConfigBuilder.getApiClient() != null) {
            throw new AskSdkException("Conflicting API client configuration: module attempting to override previously set value.");
        }
        this.skillConfigBuilder.withApiClient(apiClient);
        return this;
    }

    public SdkModuleContext setTemplateFactory(TemplateFactory templateFactory) {
        if (this.skillConfigBuilder.getTemplateFactory() != null) {
            throw new AskSdkException("Conflicting Template factory configuration: module attempting to override previously set value.");
        }
        this.skillConfigBuilder.withTemplateFactory((TemplateFactory<HandlerInput, Response>)templateFactory);
        return this;
    }
}

