/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.attributes;

import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.model.Request;
import com.amazon.ask.model.RequestEnvelope;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesManager {
    private static Logger logger = LoggerFactory.getLogger(AttributesManager.class);
    protected final RequestEnvelope requestEnvelope;
    protected final PersistenceAdapter persistenceAdapter;
    protected Map<String, Object> sessionAttributes;
    protected Map<String, Object> persistentAttributes;
    protected Map<String, Object> requestAttributes;
    protected boolean persistenceAttributesSet;

    protected AttributesManager(PersistenceAdapter persistenceAdapter, RequestEnvelope requestEnvelope) {
        this.persistenceAdapter = persistenceAdapter;
        this.requestEnvelope = requestEnvelope;
        this.requestAttributes = new HashMap<String, Object>();
        if (requestEnvelope.getSession() != null) {
            Map attributes = requestEnvelope.getSession().getAttributes() != null ? requestEnvelope.getSession().getAttributes() : new HashMap();
            this.sessionAttributes = attributes;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> getSessionAttributes() {
        if (this.requestEnvelope.getSession() == null) {
            throw new IllegalStateException("Attempting to read session attributes from out of session request");
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, Object> sessionAttributes) {
        if (this.requestEnvelope.getSession() == null) {
            throw new IllegalStateException("Attempting to set session attributes for out of session request");
        }
        this.sessionAttributes = sessionAttributes;
    }

    public Map<String, Object> getPersistentAttributes() {
        Request request = this.requestEnvelope.getRequest();
        if (this.persistenceAdapter == null) {
            throw new IllegalStateException("Attempting to read persistence attributes without configured persistence adapter");
        }
        if (!this.persistenceAttributesSet) {
            Optional<Map<String, Object>> retrievedAttributes = this.persistenceAdapter.getAttributes(this.requestEnvelope);
            if (retrievedAttributes.isPresent()) {
                logger.debug("[{}] Found existing persistence attributes", (Object)request.getRequestId());
                this.persistentAttributes = retrievedAttributes.get();
            } else {
                logger.debug("[{}] No existing persistence attributes", (Object)request.getRequestId());
                this.persistentAttributes = new HashMap<String, Object>();
            }
            this.persistenceAttributesSet = true;
        }
        return this.persistentAttributes;
    }

    public void setPersistentAttributes(Map<String, Object> persistentAttributes) {
        if (this.persistenceAdapter == null) {
            throw new IllegalStateException("Attempting to set persistence attributes without configured persistence adapter");
        }
        this.persistentAttributes = persistentAttributes;
        this.persistenceAttributesSet = true;
    }

    public Map<String, Object> getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setRequestAttributes(Map<String, Object> requestAttributes) {
        this.requestAttributes = requestAttributes;
    }

    public void savePersistentAttributes() {
        if (this.persistenceAdapter == null) {
            throw new IllegalStateException("Attempting to save persistence attributes without configured persistence adapter");
        }
        if (this.persistenceAttributesSet) {
            this.persistenceAdapter.saveAttributes(this.requestEnvelope, this.persistentAttributes);
        }
    }

    public void deletePersistentAttributes() {
        if (this.persistenceAdapter == null) {
            throw new IllegalStateException("Attempting to delete persistence attributes without a configured persistence adapter");
        }
        this.persistenceAdapter.deleteAttributes(this.requestEnvelope);
        this.persistentAttributes = null;
        this.persistenceAttributesSet = false;
    }

    public static final class Builder {
        private PersistenceAdapter persistenceAdapter;
        private RequestEnvelope requestEnvelope;

        private Builder() {
        }

        public Builder withPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
            this.persistenceAdapter = persistenceAdapter;
            return this;
        }

        public Builder withRequestEnvelope(RequestEnvelope requestEnvelope) {
            this.requestEnvelope = requestEnvelope;
            return this;
        }

        public AttributesManager build() {
            return new AttributesManager(this.persistenceAdapter, this.requestEnvelope);
        }
    }
}

