/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.LaunchRequest;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.SessionStartedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackFailedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackFinishedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackNearlyFinishedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackStartedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackStoppedRequest;
import com.amazon.speech.speechlet.interfaces.core.AccountLinkedRequest;
import com.amazon.speech.speechlet.interfaces.core.PermissionAcceptedRequest;
import com.amazon.speech.speechlet.interfaces.core.PermissionChangedRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillDisabledEventRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillEnabledEventRequest;
import com.amazon.speech.speechlet.interfaces.display.request.ElementSelectedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.NextCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PauseCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PlayCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PreviousCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.system.request.ExceptionEncounteredRequest;
import com.amazon.speech.speechlet.services.householdlist.ListCreatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListDeletedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsCreatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsDeletedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsUpdatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListUpdatedRequest;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LaunchRequest.class), @JsonSubTypes.Type(value=IntentRequest.class), @JsonSubTypes.Type(value=SessionStartedRequest.class), @JsonSubTypes.Type(value=SessionEndedRequest.class), @JsonSubTypes.Type(value=PlaybackStartedRequest.class), @JsonSubTypes.Type(value=PlaybackStoppedRequest.class), @JsonSubTypes.Type(value=PlaybackNearlyFinishedRequest.class), @JsonSubTypes.Type(value=PlaybackFinishedRequest.class), @JsonSubTypes.Type(value=PlaybackFailedRequest.class), @JsonSubTypes.Type(value=PlayCommandIssuedRequest.class), @JsonSubTypes.Type(value=PauseCommandIssuedRequest.class), @JsonSubTypes.Type(value=NextCommandIssuedRequest.class), @JsonSubTypes.Type(value=PreviousCommandIssuedRequest.class), @JsonSubTypes.Type(value=ExceptionEncounteredRequest.class), @JsonSubTypes.Type(value=ElementSelectedRequest.class), @JsonSubTypes.Type(value=SkillEnabledEventRequest.class), @JsonSubTypes.Type(value=SkillDisabledEventRequest.class), @JsonSubTypes.Type(value=PermissionAcceptedRequest.class), @JsonSubTypes.Type(value=PermissionChangedRequest.class), @JsonSubTypes.Type(value=AccountLinkedRequest.class), @JsonSubTypes.Type(value=ListItemsCreatedRequest.class), @JsonSubTypes.Type(value=ListItemsUpdatedRequest.class), @JsonSubTypes.Type(value=ListItemsDeletedRequest.class), @JsonSubTypes.Type(value=ListCreatedRequest.class), @JsonSubTypes.Type(value=ListUpdatedRequest.class), @JsonSubTypes.Type(value=ListDeletedRequest.class)})
public abstract class SpeechletRequest {
    private final String requestId;
    @JsonSerialize(using=LocaleJsonSerializer.class)
    @JsonDeserialize(using=LocaleJsonDeserializer.class)
    private final Locale locale;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    private final Date timestamp;
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    protected SpeechletRequest(SpeechletRequestBuilder builder) {
        this.requestId = builder.requestId;
        this.locale = builder.locale;
        this.timestamp = builder.timestamp;
    }

    protected SpeechletRequest(String requestId, Date timestamp, Locale locale) {
        this.requestId = requestId;
        this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
        this.locale = locale;
    }

    public final String getRequestId() {
        return this.requestId;
    }

    public final Date getTimestamp() {
        return this.timestamp != null ? new Date(this.timestamp.getTime()) : null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Locale getLocale() {
        return this.locale;
    }

    public static abstract class SpeechletRequestBuilder<T extends SpeechletRequestBuilder, S extends SpeechletRequest> {
        private String requestId;
        private Date timestamp = new Date();
        private Locale locale;

        public String getRequestId() {
            return this.requestId;
        }

        public T withRequestId(String requestId) {
            this.requestId = requestId;
            return (T)this;
        }

        public T withTimestamp(Date timestamp) {
            this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
            return (T)this;
        }

        public T withLocale(Locale locale) {
            this.locale = locale;
            return (T)this;
        }

        public abstract S build();
    }

    private static final class LocaleJsonDeserializer
    extends JsonDeserializer<Locale> {
        private LocaleJsonDeserializer() {
        }

        public Locale deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Locale.forLanguageTag(jp.getValueAsString());
        }
    }

    private static final class LocaleJsonSerializer
    extends JsonSerializer<Locale> {
        private LocaleJsonSerializer() {
        }

        public void serialize(Locale locale, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(locale.toLanguageTag());
        }
    }
}

