/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.slu.entityresolution;

import com.amazon.speech.slu.entityresolution.Status;
import com.amazon.speech.slu.entityresolution.ValueWrapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Resolution {
    private final String authority;
    private final Status status;
    private final List<ValueWrapper> values;

    public static Builder builder() {
        return new Builder();
    }

    private Resolution(Builder builder) {
        this.authority = builder.authority;
        this.status = builder.status;
        this.values = Collections.unmodifiableList(builder.values);
    }

    private Resolution(@JsonProperty(value="authority") String authority, @JsonProperty(value="status") Status status, @JsonProperty(value="values") List<ValueWrapper> values) {
        this.authority = authority;
        this.status = status;
        this.values = values != null ? Collections.unmodifiableList(values) : Collections.emptyList();
    }

    public String getAuthority() {
        return this.authority;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<ValueWrapper> getValueWrappers() {
        return this.values;
    }

    public ValueWrapper getValueWrapperAtIndex(int index) {
        return this.values.get(index);
    }

    public static final class Builder {
        private String authority;
        private Status status;
        private final List<ValueWrapper> values = new ArrayList<ValueWrapper>();

        public Builder withAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder withValues(List<ValueWrapper> values) {
            this.values.addAll(values);
            return this;
        }

        public Builder withValue(ValueWrapper value) {
            this.values.add(value);
            return this;
        }

        public Resolution build() {
            return new Resolution(this);
        }
    }
}

