/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.FilterUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapSerializer
implements ObjectSerializer {
    public static MapSerializer instance = new MapSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        TreeMap map = (TreeMap)object;
        if (out.isEnabled(SerializerFeature.SortField) && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
            try {
                map = new TreeMap(map);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (serializer.containsReference(object)) {
            serializer.writeReference(object);
            return;
        }
        SerialContext parent = serializer.getContext();
        serializer.setContext(parent, object, fieldName, 0);
        try {
            out.write('{');
            serializer.incrementIndent();
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            boolean first = true;
            if (out.isEnabled(SerializerFeature.WriteClassName)) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                out.writeString(object.getClass().getName());
                first = false;
            }
            for (Map.Entry entry : map.entrySet()) {
                List<ValueFilter> valueFilters;
                String strKey;
                Object value = entry.getValue();
                Object entryKey = entry.getKey();
                List<PropertyPreFilter> preFilters = serializer.getPropertyPreFiltersDirect();
                if (preFilters != null && preFilters.size() > 0 && (entryKey != null && !(entryKey instanceof String) ? (entryKey.getClass().isPrimitive() || entryKey instanceof Number) && !FilterUtils.applyName(serializer, object, strKey = JSON.toJSONString(entryKey)) : !FilterUtils.applyName(serializer, object, (String)entryKey))) continue;
                List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
                if (propertyFilters != null && propertyFilters.size() > 0 && (entryKey != null && !(entryKey instanceof String) ? (entryKey.getClass().isPrimitive() || entryKey instanceof Number) && !FilterUtils.apply(serializer, object, strKey = JSON.toJSONString(entryKey), value) : !FilterUtils.apply(serializer, object, (String)entryKey, value))) continue;
                List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
                if (nameFilters != null && nameFilters.size() > 0) {
                    if (entryKey == null || entryKey instanceof String) {
                        entryKey = FilterUtils.processKey(serializer, object, (String)entryKey, value);
                    } else if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                        strKey = JSON.toJSONString(entryKey);
                        entryKey = FilterUtils.processKey(serializer, object, strKey, value);
                    }
                }
                if ((valueFilters = serializer.getValueFiltersDirect()) != null && valueFilters.size() > 0) {
                    if (entryKey == null || entryKey instanceof String) {
                        value = FilterUtils.processValue(serializer, object, (String)entryKey, value);
                    } else if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                        strKey = JSON.toJSONString(entryKey);
                        value = FilterUtils.processValue(serializer, object, strKey, value);
                    }
                }
                if (value == null && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                if (entryKey instanceof String) {
                    String key = (String)entryKey;
                    if (!first) {
                        out.write(',');
                    }
                    if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                        serializer.println();
                    }
                    out.writeFieldName(key, true);
                } else {
                    if (!first) {
                        out.write(',');
                    }
                    if (out.isEnabled(SerializerFeature.BrowserCompatible) || out.isEnabled(SerializerFeature.WriteNonStringKeyAsString)) {
                        String strEntryKey = JSON.toJSONString(entryKey);
                        serializer.write(strEntryKey);
                    } else {
                        serializer.write(entryKey);
                    }
                    out.write(':');
                }
                first = false;
                if (value == null) {
                    out.writeNull();
                    continue;
                }
                Class<?> clazz = value.getClass();
                if (clazz == preClazz) {
                    preWriter.write(serializer, value, entryKey, null);
                    continue;
                }
                preClazz = clazz;
                preWriter = serializer.getObjectWriter(clazz);
                preWriter.write(serializer, value, entryKey, null);
            }
        }
        finally {
            serializer.setContext(parent);
        }
        serializer.decrementIdent();
        if (out.isEnabled(SerializerFeature.PrettyFormat) && map.size() > 0) {
            serializer.println();
        }
        out.write('}');
    }
}

