/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07;

import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.analysis.v07.handlers.sax.SharedStringsTableHandler;
import com.alibaba.excel.analysis.v07.handlers.sax.XlsxRowHandler;
import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.context.xlsx.XlsxReadContext;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.xlsx.XlsxReadWorkbookHolder;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.MapUtils;
import com.alibaba.excel.util.SheetUtils;
import com.alibaba.excel.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XlsxSaxAnalyser
implements ExcelReadExecutor {
    private static final Logger log = LoggerFactory.getLogger(XlsxSaxAnalyser.class);
    public static final PackagePartName SHARED_STRINGS_PART_NAME;
    private final XlsxReadContext xlsxReadContext;
    private final List<ReadSheet> sheetList;
    private final Map<Integer, InputStream> sheetMap;
    private final Map<Integer, CommentsTable> commentsTableMap;

    public XlsxSaxAnalyser(XlsxReadContext xlsxReadContext, InputStream decryptedStream) throws Exception {
        this.xlsxReadContext = xlsxReadContext;
        XlsxReadWorkbookHolder xlsxReadWorkbookHolder = xlsxReadContext.xlsxReadWorkbookHolder();
        OPCPackage pkg = this.readOpcPackage(xlsxReadWorkbookHolder, decryptedStream);
        xlsxReadWorkbookHolder.setOpcPackage(pkg);
        PackagePart sharedStringsTablePackagePart = pkg.getPart(SHARED_STRINGS_PART_NAME);
        if (sharedStringsTablePackagePart != null) {
            this.defaultReadCache(xlsxReadWorkbookHolder, sharedStringsTablePackagePart);
            this.analysisSharedStringsTable(sharedStringsTablePackagePart.getInputStream(), xlsxReadWorkbookHolder);
        }
        XSSFReader xssfReader = new XSSFReader(pkg);
        this.analysisUse1904WindowDate(xssfReader, xlsxReadWorkbookHolder);
        this.setStylesTable(xlsxReadWorkbookHolder, xssfReader);
        this.sheetList = new ArrayList<ReadSheet>();
        this.sheetMap = new HashMap<Integer, InputStream>();
        this.commentsTableMap = new HashMap<Integer, CommentsTable>();
        HashMap<Integer, PackageRelationshipCollection> packageRelationshipCollectionMap = MapUtils.newHashMap();
        xlsxReadWorkbookHolder.setPackageRelationshipCollectionMap(packageRelationshipCollectionMap);
        XSSFReader.SheetIterator ite = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        int index = 0;
        if (!ite.hasNext()) {
            throw new ExcelAnalysisException("Can not find any sheet!");
        }
        while (ite.hasNext()) {
            PackageRelationshipCollection packageRelationshipCollection;
            CommentsTable commentsTable;
            InputStream inputStream = ite.next();
            this.sheetList.add(new ReadSheet(index, ite.getSheetName()));
            this.sheetMap.put(index, inputStream);
            if (xlsxReadContext.readWorkbookHolder().getExtraReadSet().contains((Object)CellExtraTypeEnum.COMMENT) && null != (commentsTable = ite.getSheetComments())) {
                this.commentsTableMap.put(index, commentsTable);
            }
            if (xlsxReadContext.readWorkbookHolder().getExtraReadSet().contains((Object)CellExtraTypeEnum.HYPERLINK) && (packageRelationshipCollection = (PackageRelationshipCollection)Optional.ofNullable(ite.getSheetPart()).map(packagePart -> {
                try {
                    return packagePart.getRelationships();
                }
                catch (InvalidFormatException e) {
                    log.warn("Reading the Relationship failed", (Throwable)e);
                    return null;
                }
            }).orElse(null)) != null) {
                packageRelationshipCollectionMap.put(index, packageRelationshipCollection);
            }
            ++index;
        }
    }

    private void setStylesTable(XlsxReadWorkbookHolder xlsxReadWorkbookHolder, XSSFReader xssfReader) {
        try {
            xlsxReadWorkbookHolder.setStylesTable(xssfReader.getStylesTable());
        }
        catch (Exception e) {
            log.warn("Currently excel cannot get style information, but it doesn't affect the data analysis.You can try to save the file with office again or ignore the current error.", (Throwable)e);
        }
    }

    private void defaultReadCache(XlsxReadWorkbookHolder xlsxReadWorkbookHolder, PackagePart sharedStringsTablePackagePart) {
        ReadCache readCache = xlsxReadWorkbookHolder.getReadCacheSelector().readCache(sharedStringsTablePackagePart);
        xlsxReadWorkbookHolder.setReadCache(readCache);
        readCache.init(this.xlsxReadContext);
    }

    private void analysisUse1904WindowDate(XSSFReader xssfReader, XlsxReadWorkbookHolder xlsxReadWorkbookHolder) throws Exception {
        if (xlsxReadWorkbookHolder.globalConfiguration().getUse1904windowing() != null) {
            return;
        }
        InputStream workbookXml = xssfReader.getWorkbookData();
        WorkbookDocument ctWorkbook = WorkbookDocument.Factory.parse((InputStream)workbookXml);
        CTWorkbook wb = ctWorkbook.getWorkbook();
        CTWorkbookPr prefix = wb.getWorkbookPr();
        if (prefix != null && prefix.getDate1904()) {
            xlsxReadWorkbookHolder.getGlobalConfiguration().setUse1904windowing(Boolean.TRUE);
        } else {
            xlsxReadWorkbookHolder.getGlobalConfiguration().setUse1904windowing(Boolean.FALSE);
        }
    }

    private void analysisSharedStringsTable(InputStream sharedStringsTableInputStream, XlsxReadWorkbookHolder xlsxReadWorkbookHolder) throws Exception {
        SharedStringsTableHandler handler = new SharedStringsTableHandler(xlsxReadWorkbookHolder.getReadCache());
        this.parseXmlSource(sharedStringsTableInputStream, handler);
        xlsxReadWorkbookHolder.getReadCache().putFinished();
    }

    private OPCPackage readOpcPackage(XlsxReadWorkbookHolder xlsxReadWorkbookHolder, InputStream decryptedStream) throws Exception {
        if (decryptedStream == null && xlsxReadWorkbookHolder.getFile() != null) {
            return OPCPackage.open((File)xlsxReadWorkbookHolder.getFile());
        }
        if (xlsxReadWorkbookHolder.getMandatoryUseInputStream().booleanValue()) {
            if (decryptedStream != null) {
                return OPCPackage.open((InputStream)decryptedStream);
            }
            return OPCPackage.open((InputStream)xlsxReadWorkbookHolder.getInputStream());
        }
        File readTempFile = FileUtils.createCacheTmpFile();
        xlsxReadWorkbookHolder.setTempFile(readTempFile);
        File tempFile = new File(readTempFile.getPath(), UUID.randomUUID().toString() + ".xlsx");
        if (decryptedStream != null) {
            FileUtils.writeToFile(tempFile, decryptedStream, false);
        } else {
            FileUtils.writeToFile(tempFile, xlsxReadWorkbookHolder.getInputStream(), xlsxReadWorkbookHolder.getAutoCloseStream());
        }
        return OPCPackage.open((File)tempFile, (PackageAccess)PackageAccess.READ);
    }

    @Override
    public List<ReadSheet> sheetList() {
        return this.sheetList;
    }

    private void parseXmlSource(InputStream inputStream, ContentHandler handler) {
        InputSource inputSource = new InputSource(inputStream);
        try {
            String xlsxSAXParserFactoryName = this.xlsxReadContext.xlsxReadWorkbookHolder().getSaxParserFactoryName();
            SAXParserFactory saxFactory = StringUtils.isEmpty(xlsxSAXParserFactoryName) ? SAXParserFactory.newInstance() : SAXParserFactory.newInstance(xlsxSAXParserFactoryName, null);
            try {
                saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(inputSource);
            inputStream.close();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ExcelAnalysisException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ExcelAnalysisException("Can not close 'inputStream'!");
                }
            }
        }
    }

    @Override
    public void execute() {
        for (ReadSheet readSheet : this.sheetList) {
            if ((readSheet = SheetUtils.match(readSheet, this.xlsxReadContext)) == null) continue;
            this.xlsxReadContext.currentSheet(readSheet);
            this.parseXmlSource(this.sheetMap.get(readSheet.getSheetNo()), new XlsxRowHandler(this.xlsxReadContext));
            this.readComments(readSheet);
            this.xlsxReadContext.analysisEventProcessor().endSheet(this.xlsxReadContext);
        }
    }

    private void readComments(ReadSheet readSheet) {
        if (!this.xlsxReadContext.readWorkbookHolder().getExtraReadSet().contains((Object)CellExtraTypeEnum.COMMENT)) {
            return;
        }
        CommentsTable commentsTable = this.commentsTableMap.get(readSheet.getSheetNo());
        if (commentsTable == null) {
            return;
        }
        Iterator cellAddresses = commentsTable.getCellAddresses();
        while (cellAddresses.hasNext()) {
            CellAddress cellAddress = (CellAddress)cellAddresses.next();
            XSSFComment cellComment = commentsTable.findCellComment(cellAddress);
            CellExtra cellExtra = new CellExtra(CellExtraTypeEnum.COMMENT, cellComment.getString().toString(), cellAddress.getRow(), cellAddress.getColumn());
            this.xlsxReadContext.readSheetHolder().setCellExtra(cellExtra);
            this.xlsxReadContext.analysisEventProcessor().extra(this.xlsxReadContext);
        }
    }

    static {
        try {
            SHARED_STRINGS_PART_NAME = PackagingURIHelper.createPartName((String)"/xl/sharedStrings.xml");
        }
        catch (InvalidFormatException e) {
            log.error("Initialize the XlsxSaxAnalyser failure", (Throwable)e);
            throw new ExcelAnalysisException("Initialize the XlsxSaxAnalyser failure", e);
        }
    }
}

