/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos.transform;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class TransformInterface {
    public static final String METHOD_ROTATE = "flickr.photos.transform.rotate";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public TransformInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public void rotate(String photoId, int degrees) throws IOException, SAXException, FlickrException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_ROTATE));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("photo_id", photoId));
        parameters.add(new Parameter("degrees", String.valueOf(degrees)));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

