/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos;

import com.aetrion.flickr.people.User;
import com.aetrion.flickr.photos.Editability;
import com.aetrion.flickr.photos.GeoData;
import com.aetrion.flickr.photos.Note;
import com.aetrion.flickr.photos.Permissions;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photos.PhotoUrl;
import com.aetrion.flickr.tags.Tag;
import com.aetrion.flickr.util.XMLUtilities;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PhotoUtils {
    private PhotoUtils() {
    }

    private static String getAttribute(String name, Element firstElement, Element secondElement) {
        String val = firstElement.getAttribute(name);
        if (val.length() == 0 && secondElement != null) {
            val = secondElement.getAttribute(name);
        }
        return val;
    }

    public static final Photo createPhoto(Element photoElement) {
        return PhotoUtils.createPhoto(photoElement, null);
    }

    public static final Photo createPhoto(Element photoElement, Element defaultElement) {
        int i;
        User owner;
        Photo photo = new Photo();
        photo.setId(photoElement.getAttribute("id"));
        photo.setPlaceId(photoElement.getAttribute("place_id"));
        photo.setSecret(photoElement.getAttribute("secret"));
        photo.setServer(photoElement.getAttribute("server"));
        photo.setFarm(photoElement.getAttribute("farm"));
        photo.setViews(photoElement.getAttribute("views"));
        photo.setRotation(photoElement.getAttribute("rotation"));
        photo.setFavorite("1".equals(photoElement.getAttribute("isfavorite")));
        photo.setLicense(photoElement.getAttribute("license"));
        photo.setOriginalFormat(photoElement.getAttribute("originalformat"));
        photo.setOriginalSecret(photoElement.getAttribute("originalsecret"));
        photo.setIconServer(photoElement.getAttribute("iconserver"));
        photo.setIconFarm(photoElement.getAttribute("iconfarm"));
        photo.setDateTaken(photoElement.getAttribute("datetaken"));
        photo.setDatePosted(photoElement.getAttribute("dateupload"));
        photo.setLastUpdate(photoElement.getAttribute("lastupdate"));
        photo.setDateAdded(photoElement.getAttribute("dateadded"));
        try {
            if (photo.getOriginalFormat().equals("")) {
                photo.setOriginalFormat("jpg");
            }
        }
        catch (NullPointerException e) {
            photo.setOriginalFormat("jpg");
        }
        try {
            Element ownerElement = (Element)photoElement.getElementsByTagName("owner").item(0);
            if (ownerElement == null) {
                owner = new User();
                owner.setId(PhotoUtils.getAttribute("owner", photoElement, defaultElement));
                owner.setUsername(PhotoUtils.getAttribute("ownername", photoElement, defaultElement));
                photo.setOwner(owner);
                photo.setUrl("http://flickr.com/photos/" + owner.getId() + "/" + photo.getId());
            } else {
                owner = new User();
                owner.setId(ownerElement.getAttribute("nsid"));
                String username = ownerElement.getAttribute("username");
                String ownername = ownerElement.getAttribute("ownername");
                if (username != null && !"".equals(username)) {
                    owner.setUsername(username);
                } else if (ownername != null && !"".equals(ownername)) {
                    owner.setUsername(ownername);
                }
                owner.setUsername(ownerElement.getAttribute("username"));
                owner.setRealName(ownerElement.getAttribute("realname"));
                owner.setLocation(ownerElement.getAttribute("location"));
                photo.setOwner(owner);
                photo.setUrl("http://flickr.com/photos/" + owner.getId() + "/" + photo.getId());
            }
        }
        catch (IndexOutOfBoundsException e) {
            owner = new User();
            owner.setId(photoElement.getAttribute("owner"));
            owner.setUsername(photoElement.getAttribute("ownername"));
            photo.setOwner(owner);
            photo.setUrl("http://flickr.com/photos/" + owner.getId() + "/" + photo.getId());
        }
        try {
            photo.setTitle(XMLUtilities.getChildValue(photoElement, "title"));
            if (photo.getTitle() == null) {
                photo.setTitle(photoElement.getAttribute("title"));
            }
        }
        catch (IndexOutOfBoundsException e) {
            photo.setTitle(photoElement.getAttribute("title"));
        }
        try {
            photo.setDescription(XMLUtilities.getChildValue(photoElement, "description"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Element visibilityElement = (Element)photoElement.getElementsByTagName("visibility").item(0);
            photo.setPublicFlag("1".equals(visibilityElement.getAttribute("ispublic")));
            photo.setFriendFlag("1".equals(visibilityElement.getAttribute("isfriend")));
            photo.setFamilyFlag("1".equals(visibilityElement.getAttribute("isfamily")));
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            photo.setPublicFlag("1".equals(photoElement.getAttribute("ispublic")));
            photo.setFriendFlag("1".equals(photoElement.getAttribute("isfriend")));
            photo.setFamilyFlag("1".equals(photoElement.getAttribute("isfamily")));
        }
        try {
            Element datesElement = XMLUtilities.getChild(photoElement, "dates");
            photo.setDatePosted(datesElement.getAttribute("posted"));
            photo.setDateTaken(datesElement.getAttribute("taken"));
            photo.setTakenGranularity(datesElement.getAttribute("takengranularity"));
            photo.setLastUpdate(datesElement.getAttribute("lastupdate"));
        }
        catch (IndexOutOfBoundsException e) {
            photo.setDateTaken(photoElement.getAttribute("datetaken"));
        }
        catch (NullPointerException e) {
            photo.setDateTaken(photoElement.getAttribute("datetaken"));
        }
        NodeList permissionsNodes = photoElement.getElementsByTagName("permissions");
        if (permissionsNodes.getLength() > 0) {
            Element permissionsElement = (Element)permissionsNodes.item(0);
            Permissions permissions = new Permissions();
            permissions.setComment(permissionsElement.getAttribute("permcomment"));
            permissions.setAddmeta(permissionsElement.getAttribute("permaddmeta"));
        }
        try {
            Element editabilityElement = (Element)photoElement.getElementsByTagName("editability").item(0);
            Editability editability = new Editability();
            editability.setComment("1".equals(editabilityElement.getAttribute("cancomment")));
            editability.setAddmeta("1".equals(editabilityElement.getAttribute("canaddmeta")));
            photo.setEditability(editability);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element commentsElement = (Element)photoElement.getElementsByTagName("comments").item(0);
            photo.setComments(((Text)commentsElement.getFirstChild()).getData());
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element notesElement = (Element)photoElement.getElementsByTagName("notes").item(0);
            ArrayList<Note> notes = new ArrayList<Note>();
            NodeList noteNodes = notesElement.getElementsByTagName("note");
            for (i = 0; i < noteNodes.getLength(); ++i) {
                Element noteElement = (Element)noteNodes.item(i);
                Note note = new Note();
                note.setId(noteElement.getAttribute("id"));
                note.setAuthor(noteElement.getAttribute("author"));
                note.setAuthorName(noteElement.getAttribute("authorname"));
                note.setBounds(noteElement.getAttribute("x"), noteElement.getAttribute("y"), noteElement.getAttribute("w"), noteElement.getAttribute("h"));
                note.setText(noteElement.getTextContent());
                notes.add(note);
            }
            photo.setNotes(notes);
        }
        catch (IndexOutOfBoundsException e) {
            photo.setNotes(new ArrayList());
        }
        catch (NullPointerException e) {
            photo.setNotes(new ArrayList());
        }
        try {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            String tagsAttr = photoElement.getAttribute("tags");
            if (!tagsAttr.equals("")) {
                String[] values = tagsAttr.split("\\s+");
                for (i = 0; i < values.length; ++i) {
                    Tag tag = new Tag();
                    tag.setValue(values[i]);
                    tags.add(tag);
                }
            } else {
                try {
                    Element tagsElement = (Element)photoElement.getElementsByTagName("tags").item(0);
                    NodeList tagNodes = tagsElement.getElementsByTagName("tag");
                    for (int i2 = 0; i2 < tagNodes.getLength(); ++i2) {
                        Element tagElement = (Element)tagNodes.item(i2);
                        Tag tag = new Tag();
                        tag.setId(tagElement.getAttribute("id"));
                        tag.setAuthor(tagElement.getAttribute("author"));
                        tag.setRaw(tagElement.getAttribute("raw"));
                        tag.setValue(((Text)tagElement.getFirstChild()).getData());
                        tags.add(tag);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            photo.setTags(tags);
        }
        catch (NullPointerException e) {
            photo.setTags(new ArrayList());
        }
        try {
            Element urlsElement = (Element)photoElement.getElementsByTagName("urls").item(0);
            ArrayList urls = new ArrayList();
            NodeList urlNodes = urlsElement.getElementsByTagName("url");
            for (int i3 = 0; i3 < urlNodes.getLength(); ++i3) {
                Element urlElement = (Element)urlNodes.item(i3);
                PhotoUrl photoUrl = new PhotoUrl();
                photoUrl.setType(urlElement.getAttribute("type"));
                photoUrl.setUrl(XMLUtilities.getValue(urlElement));
                if (!photoUrl.getType().equals("photopage")) continue;
                photo.setUrl(photoUrl.getUrl());
            }
            photo.setUrls(urls);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            photo.setUrls(new ArrayList());
        }
        String longitude = null;
        String latitude = null;
        String accuracy = null;
        try {
            Element geoElement = (Element)photoElement.getElementsByTagName("location").item(0);
            longitude = geoElement.getAttribute("longitude");
            latitude = geoElement.getAttribute("latitude");
            accuracy = geoElement.getAttribute("accuracy");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            try {
                longitude = photoElement.getAttribute("longitude");
                latitude = photoElement.getAttribute("latitude");
                accuracy = photoElement.getAttribute("accuracy");
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
        }
        if (!(longitude == null || latitude == null || longitude.length() <= 0 || latitude.length() <= 0 || "0".equals(longitude) && "0".equals(latitude))) {
            photo.setGeoData(new GeoData(longitude, latitude, accuracy));
        }
        return photo;
    }

    public static final PhotoList createPhotoList(Element photosElement) {
        PhotoList photos = new PhotoList();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }
}

