/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.db;

import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.common.util.MavenProjects;
import cn.ponfee.scheduler.common.util.Numbers;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBTools {
    public static final String DB_NAME = "distributed_scheduler";
    public static final String DB_SCRIPT_PATH = MavenProjects.getProjectBaseDir() + "/../db-script/JOB_TABLES_DDL.sql";

    public static JdbcTemplate createJdbcTemplate(String url, String user, String password) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setUsername(user);
        config.setPassword(password);
        return new JdbcTemplate((DataSource)new HikariDataSource(config));
    }

    public static String loadScript() throws Exception {
        return IOUtils.toString((InputStream)new FileInputStream(DB_SCRIPT_PATH), (Charset)StandardCharsets.UTF_8);
    }

    public static void testNativeConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver);
        Connection conn = DriverManager.getConnection(url, user, password);
        System.out.println("Testing Database, URL=" + url);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS test");
        stat.execute("CREATE TABLE IF NOT EXISTS test(id INT, `name` VARCHAR(30))");
        ArrayList<String> data = new ArrayList<String>();
        PreparedStatement insertSql = conn.prepareStatement("INSERT INTO test VALUES(?, ?)");
        for (int i = 0; i < 100; ++i) {
            String str = RandomStringUtils.randomAlphanumeric((int)4);
            data.add(str);
            insertSql.setInt(1, i);
            insertSql.setString(2, str);
            insertSql.execute();
        }
        ArrayList<String> result = new ArrayList<String>();
        ResultSet resultSet = conn.prepareStatement("SELECT `name` FROM test ORDER BY id ASC").executeQuery();
        while (resultSet.next()) {
            result.add(resultSet.getString(1));
        }
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(data, result));
        stat.execute("DROP TABLE IF EXISTS test");
        conn.close();
    }

    public static void testJdbcTemplate(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.execute("DROP TABLE IF EXISTS test");
        jdbcTemplate.execute("CREATE TABLE IF NOT EXISTS test(id INT, `name` VARCHAR(30))");
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String str = RandomStringUtils.randomAlphanumeric((int)4);
            data.add(str);
            jdbcTemplate.update("INSERT INTO test VALUES(?, ?)", new Object[]{i, str});
        }
        List result = jdbcTemplate.queryForList("SELECT `name` FROM test ORDER BY id ASC", String.class);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(data, (Collection)result));
        jdbcTemplate.execute("DROP TABLE IF EXISTS test");
    }

    public static void testMysql(JdbcTemplate jdbcTemplate) {
        String version = (String)jdbcTemplate.queryForObject("SELECT VERSION()", String.class);
        System.out.println("Version: " + version);
        Integer value = (Integer)jdbcTemplate.queryForObject("SELECT 1", Integer.class);
        Assert.assertTrue((value == 1 ? 1 : 0) != 0);
    }

    public static void testQuerySchedJob(JdbcTemplate jdbcTemplate) {
        List result = jdbcTemplate.queryForList("SELECT * FROM sched_job ORDER BY id ASC");
        Assert.assertEquals((long)3988904755200L, (long)Numbers.toLong(((Map)result.get(0)).get("job_id")));
        System.out.println("Query result: " + Jsons.toJson((Object)result));
    }
}

