/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor;

import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.ScanJobHeartbeatThread;
import cn.ponfee.scheduler.supervisor.ScanTrackHeartbeatThread;
import cn.ponfee.scheduler.supervisor.manager.JobManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.Assert;

public class SupervisorStartup
implements AutoCloseable {
    private final Supervisor currentSupervisor;
    private final ScanJobHeartbeatThread scanJobHeartbeatThread;
    private final ScanTrackHeartbeatThread scanTrackHeartbeatThread;
    private final TaskDispatcher taskDispatcher;
    private final SupervisorRegistry supervisorRegistry;
    private final AtomicBoolean start = new AtomicBoolean(false);

    private SupervisorStartup(Supervisor currentSupervisor, int jobHeartbeatIntervalSeconds, int trackHeartbeatIntervalSeconds, SupervisorRegistry supervisorRegistry, JobManager jobManager, DoInLocked scanJobLocked, DoInLocked scanTrackLocked, TaskDispatcher taskDispatcher) {
        Assert.notNull((Object)currentSupervisor, (String)"Current supervisor cannot null.");
        Assert.isTrue((jobHeartbeatIntervalSeconds > 0 ? 1 : 0) != 0, (String)"Job heart beat interval seconds must be greater zero.");
        Assert.isTrue((trackHeartbeatIntervalSeconds > 0 ? 1 : 0) != 0, (String)"Track heart beat interval seconds must be greater zero.");
        Assert.notNull((Object)supervisorRegistry, (String)"Supervisor registry cannot null.");
        Assert.notNull((Object)jobManager, (String)"Job manager cannot null.");
        Assert.notNull((Object)scanJobLocked, (String)"Scan job locked cannot null.");
        Assert.notNull((Object)scanTrackLocked, (String)"Scan track locked cannot null.");
        Assert.notNull((Object)taskDispatcher, (String)"Task dispatcher cannot null.");
        this.currentSupervisor = currentSupervisor;
        this.supervisorRegistry = supervisorRegistry;
        this.scanJobHeartbeatThread = new ScanJobHeartbeatThread(jobHeartbeatIntervalSeconds, scanJobLocked, jobManager);
        this.scanTrackHeartbeatThread = new ScanTrackHeartbeatThread(trackHeartbeatIntervalSeconds, scanTrackLocked, jobManager);
        this.taskDispatcher = taskDispatcher;
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        this.scanJobHeartbeatThread.start();
        this.scanTrackHeartbeatThread.start();
        this.supervisorRegistry.register((Server)this.currentSupervisor);
    }

    @Override
    public void close() {
        Throwables.caught(() -> ((SupervisorRegistry)this.supervisorRegistry).close());
        Throwables.caught(() -> ((ScanTrackHeartbeatThread)this.scanTrackHeartbeatThread).toStop());
        Throwables.caught(() -> ((ScanJobHeartbeatThread)this.scanJobHeartbeatThread).toStop());
        Throwables.caught(() -> ((TaskDispatcher)this.taskDispatcher).close());
        Throwables.caught(() -> this.scanTrackHeartbeatThread.doStop(1000L));
        Throwables.caught(() -> this.scanJobHeartbeatThread.doStop(1000L));
    }

    public static SupervisorStartupBuilder builder() {
        return new SupervisorStartupBuilder();
    }

    public static class SupervisorStartupBuilder {
        private Supervisor currentSupervisor;
        private int jobHeartbeatIntervalSeconds;
        private int trackHeartbeatIntervalSeconds;
        private SupervisorRegistry supervisorRegistry;
        private JobManager jobManager;
        private DoInLocked scanJobLocked;
        private DoInLocked scanTrackLocked;
        private TaskDispatcher taskDispatcher;

        public SupervisorStartupBuilder currentSupervisor(Supervisor currentSupervisor) {
            this.currentSupervisor = currentSupervisor;
            return this;
        }

        public SupervisorStartupBuilder jobHeartbeatIntervalSeconds(int jobHeartbeatIntervalSeconds) {
            this.jobHeartbeatIntervalSeconds = jobHeartbeatIntervalSeconds;
            return this;
        }

        public SupervisorStartupBuilder trackHeartbeatIntervalSeconds(int trackHeartbeatIntervalSeconds) {
            this.trackHeartbeatIntervalSeconds = trackHeartbeatIntervalSeconds;
            return this;
        }

        public SupervisorStartupBuilder supervisorRegistry(SupervisorRegistry supervisorRegistry) {
            this.supervisorRegistry = supervisorRegistry;
            return this;
        }

        public SupervisorStartupBuilder jobManager(JobManager jobManager) {
            this.jobManager = jobManager;
            return this;
        }

        public SupervisorStartupBuilder scanJobLocked(DoInLocked scanJobLocked) {
            this.scanJobLocked = scanJobLocked;
            return this;
        }

        public SupervisorStartupBuilder scanTrackLocked(DoInLocked scanTrackLocked) {
            this.scanTrackLocked = scanTrackLocked;
            return this;
        }

        public SupervisorStartupBuilder taskDispatcher(TaskDispatcher taskDispatcher) {
            this.taskDispatcher = taskDispatcher;
            return this;
        }

        public SupervisorStartup build() {
            return new SupervisorStartup(this.currentSupervisor, this.jobHeartbeatIntervalSeconds, this.trackHeartbeatIntervalSeconds, this.supervisorRegistry, this.jobManager, this.scanJobLocked, this.scanTrackLocked, this.taskDispatcher);
        }
    }
}

