/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.spring;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisKeyRenewal {
    private static final Logger LOG = LoggerFactory.getLogger(RedisKeyRenewal.class);
    private final Lock lock = new ReentrantLock();
    private final RedisTemplate<?, ?> redisTemplate;
    private final byte[] byteKey;
    private final String stringKey;
    private final long ttlMillis;
    private final long intervalMillis;
    private volatile long nextRenewTimeMillis = 0L;

    public RedisKeyRenewal(RedisTemplate<?, ?> redisTemplate, String stringKey) {
        this(redisTemplate, stringKey.getBytes(StandardCharsets.UTF_8));
    }

    public RedisKeyRenewal(RedisTemplate<?, ?> redisTemplate, byte[] byteKey) {
        this(redisTemplate, byteKey, 2592000000L, 600000L);
    }

    public RedisKeyRenewal(RedisTemplate<?, ?> redisTemplate, String stringKey, long ttlMillis, long intervalMillis) {
        this(redisTemplate, stringKey.getBytes(StandardCharsets.UTF_8), ttlMillis, intervalMillis);
    }

    public RedisKeyRenewal(RedisTemplate<?, ?> redisTemplate, byte[] byteKey, long ttlMillis, long intervalMillis) {
        this.redisTemplate = redisTemplate;
        this.byteKey = byteKey;
        this.stringKey = new String(byteKey, StandardCharsets.UTF_8);
        this.ttlMillis = ttlMillis;
        this.intervalMillis = Math.min(intervalMillis, ttlMillis - 1L);
    }

    public void renewIfNecessary() {
        if (System.currentTimeMillis() < this.nextRenewTimeMillis) {
            return;
        }
        if (this.lock.tryLock()) {
            try {
                if (System.currentTimeMillis() < this.nextRenewTimeMillis) {
                    return;
                }
                this.redisTemplate.execute(conn -> conn.pExpire(this.byteKey, this.ttlMillis));
                this.nextRenewTimeMillis = System.currentTimeMillis() + this.intervalMillis;
                LOG.debug("Renewed redis key '{}' successful.", (Object)this.stringKey);
            }
            catch (Exception e) {
                LOG.warn("Renew redis key '" + this.stringKey + "' occur error.", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

