/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import redis.embedded.Redis;
import redis.embedded.RedisClusterBuilder;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisCluster
implements Redis {
    private final List<Redis> sentinels = new LinkedList<Redis>();
    private final List<Redis> servers = new LinkedList<Redis>();

    RedisCluster(List<Redis> sentinels, List<Redis> servers) {
        this.servers.addAll(servers);
        this.sentinels.addAll(sentinels);
    }

    @Override
    public boolean isActive() {
        for (Redis redis : this.sentinels) {
            if (redis.isActive()) continue;
            return false;
        }
        for (Redis redis : this.servers) {
            if (redis.isActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void start() throws EmbeddedRedisException {
        for (Redis redis : this.sentinels) {
            redis.start();
        }
        for (Redis redis : this.servers) {
            redis.start();
        }
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        for (Redis redis : this.sentinels) {
            redis.stop();
        }
        for (Redis redis : this.servers) {
            redis.stop();
        }
    }

    @Override
    public List<Integer> ports() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.addAll(this.sentinelPorts());
        ports.addAll(this.serverPorts());
        return ports;
    }

    @Override
    public List<Integer> tlsPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.addAll(this.sentinelTlsPorts());
        ports.addAll(this.serverTlsPorts());
        return ports;
    }

    public List<Redis> sentinels() {
        return Lists.newLinkedList(this.sentinels);
    }

    public List<Integer> sentinelPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Redis redis : this.sentinels) {
            ports.addAll(redis.ports());
        }
        return ports;
    }

    public List<Integer> sentinelTlsPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Redis redis : this.sentinels) {
            ports.addAll(redis.tlsPorts());
        }
        return ports;
    }

    public List<Redis> servers() {
        return Lists.newLinkedList(this.servers);
    }

    public List<Integer> serverPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Redis redis : this.servers) {
            ports.addAll(redis.ports());
        }
        return ports;
    }

    public List<Integer> serverTlsPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Redis redis : this.servers) {
            ports.addAll(redis.tlsPorts());
        }
        return ports;
    }

    public static RedisClusterBuilder builder() {
        return new RedisClusterBuilder();
    }
}

