/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.SearchManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.preferencefragment.R;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class Dialog
implements DialogInterface,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener {
    private static final String TAG = "Dialog";
    private Activity mOwnerActivity;
    final Context mContext;
    final WindowManager mWindowManager;
    Window mWindow;
    View mDecor;
    protected boolean mCancelable = true;
    private String mCancelAndDismissTaken;
    private Message mCancelMessage;
    private Message mDismissMessage;
    private Message mShowMessage;
    private DialogInterface.OnKeyListener mOnKeyListener;
    private boolean mCreated = false;
    private boolean mShowing = false;
    private boolean mCanceled = false;
    private final Handler mHandler = new Handler();
    private static final int DISMISS = 67;
    private static final int CANCEL = 68;
    private static final int SHOW = 69;
    private Handler mListenersHandler;
    private final Runnable mDismissAction = new Runnable(){

        @Override
        public void run() {
            Dialog.this.dismissDialog();
        }
    };
    private static final String DIALOG_SHOWING_TAG = "android:dialogShowing";
    private static final String DIALOG_HIERARCHY_TAG = "android:dialogHierarchy";

    public Dialog(Context context) {
        this(context, 0, true);
    }

    public Dialog(Context context, int theme) {
        this(context, theme, true);
    }

    Dialog(Context context, int theme, boolean createContextThemeWrapper) {
        if (createContextThemeWrapper) {
            if (theme == 0) {
                TypedValue outValue = new TypedValue();
                context.getTheme().resolveAttribute(R.attr.dialogTheme, outValue, true);
                theme = outValue.resourceId;
            }
            this.mContext = new ContextThemeWrapper(context, theme);
        } else {
            this.mContext = context;
        }
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        Window w = null;
        String POLICYMANAGER_CLASS_NAME = "com.android.internal.policy.PolicyManager";
        try {
            Class<?> policyClass = Class.forName(POLICYMANAGER_CLASS_NAME);
            Method[] meths = policyClass.getMethods();
            Method makenewwindow = null;
            for (int i = 0; !(i >= meths.length || meths[i].getName().endsWith("makeNewWindow") && (makenewwindow = meths[i]) != null); ++i) {
            }
            w = (Window)makenewwindow.invoke(null, this.mContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mWindow = w;
        w.setCallback((Window.Callback)this);
        w.setWindowManager(this.mWindowManager, null, null);
        w.setGravity(17);
        this.mListenersHandler = new ListenersHandler(this);
    }

    @Deprecated
    protected Dialog(Context context, boolean cancelable, Message cancelCallback) {
        this(context);
        this.mCancelable = cancelable;
        this.mCancelMessage = cancelCallback;
    }

    protected Dialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this(context);
        this.mCancelable = cancelable;
        this.setOnCancelListener(cancelListener);
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final void setOwnerActivity(Activity activity) {
        this.mOwnerActivity = activity;
        this.getWindow().setVolumeControlStream(this.mOwnerActivity.getVolumeControlStream());
    }

    public final Activity getOwnerActivity() {
        return this.mOwnerActivity;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        if (this.mShowing) {
            if (this.mDecor != null) {
                this.mDecor.setVisibility(0);
            }
            return;
        }
        this.mCanceled = false;
        if (!this.mCreated) {
            this.dispatchOnCreate(null);
        }
        this.onStart();
        this.mDecor = this.mWindow.getDecorView();
        WindowManager.LayoutParams l = this.mWindow.getAttributes();
        if ((l.softInputMode & 0x100) == 0) {
            WindowManager.LayoutParams nl = new WindowManager.LayoutParams();
            nl.copyFrom(l);
            nl.softInputMode |= 0x100;
            l = nl;
        }
        this.mWindowManager.addView(this.mDecor, (ViewGroup.LayoutParams)l);
        this.mShowing = true;
        this.sendShowMessage();
    }

    public void hide() {
        if (this.mDecor != null) {
            this.mDecor.setVisibility(8);
        }
    }

    public void dismiss() {
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.dismissDialog();
        } else {
            this.mHandler.post(this.mDismissAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dismissDialog() {
        if (this.mDecor == null || !this.mShowing) {
            return;
        }
        try {
            this.mWindowManager.removeViewImmediate(this.mDecor);
        }
        finally {
            this.mDecor = null;
            this.mWindow.closeAllPanels();
            this.onStop();
            this.mShowing = false;
            this.sendDismissMessage();
        }
    }

    private void sendDismissMessage() {
        if (this.mDismissMessage != null) {
            Message.obtain((Message)this.mDismissMessage).sendToTarget();
        }
    }

    private void sendShowMessage() {
        if (this.mShowMessage != null) {
            Message.obtain((Message)this.mShowMessage).sendToTarget();
        }
    }

    void dispatchOnCreate(Bundle savedInstanceState) {
        if (!this.mCreated) {
            this.onCreate(savedInstanceState);
            this.mCreated = true;
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putBoolean(DIALOG_SHOWING_TAG, this.mShowing);
        if (this.mCreated) {
            bundle.putBundle(DIALOG_HIERARCHY_TAG, this.mWindow.saveHierarchyState());
        }
        return bundle;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        Bundle dialogHierarchyState = savedInstanceState.getBundle(DIALOG_HIERARCHY_TAG);
        if (dialogHierarchyState == null) {
            return;
        }
        this.dispatchOnCreate(savedInstanceState);
        this.mWindow.restoreHierarchyState(dialogHierarchyState);
        if (savedInstanceState.getBoolean(DIALOG_SHOWING_TAG)) {
            this.show();
        }
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public View getCurrentFocus() {
        return this.mWindow != null ? this.mWindow.getCurrentFocus() : null;
    }

    public View findViewById(int id2) {
        return this.mWindow.findViewById(id2);
    }

    public void setContentView(int layoutResID) {
        this.mWindow.setContentView(layoutResID);
    }

    public void setContentView(View view) {
        this.mWindow.setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.mWindow.setContentView(view, params);
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.mWindow.addContentView(view, params);
    }

    public void setTitle(CharSequence title) {
        this.mWindow.setTitle(title);
        this.mWindow.getAttributes().setTitle(title);
    }

    public void setTitle(int titleId) {
        this.setTitle(this.mContext.getText(titleId));
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            event.startTracking();
            return true;
        }
        return false;
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.isTracking() && !event.isCanceled()) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    public void onBackPressed() {
        if (this.mCancelable) {
            this.cancel();
        }
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mCancelable && this.mShowing && event.getAction() == 0 && this.isOutOfBounds(event)) {
            this.cancel();
            return true;
        }
        return false;
    }

    private boolean isOutOfBounds(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get((Context)this.mContext).getScaledWindowTouchSlop();
        View decorView = this.getWindow().getDecorView();
        return x < -slop || y < -slop || x > decorView.getWidth() + slop || y > decorView.getHeight() + slop;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams params) {
        if (this.mDecor != null) {
            this.mWindowManager.updateViewLayout(this.mDecor, (ViewGroup.LayoutParams)params);
        }
    }

    public void onContentChanged() {
    }

    public void onWindowFocusChanged(boolean hasFocus) {
    }

    public void onAttachedToWindow() {
    }

    public void onDetachedFromWindow() {
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mOnKeyListener != null && this.mOnKeyListener.onKey((DialogInterface)this, event.getKeyCode(), event)) {
            return true;
        }
        if (this.mWindow.superDispatchKeyEvent(event)) {
            return true;
        }
        return event.dispatch((KeyEvent.Callback)this, this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null, (Object)this);
    }

    @TargetApi(value=11)
    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        if (this.mWindow.superDispatchKeyShortcutEvent(event)) {
            return true;
        }
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mWindow.superDispatchTouchEvent(ev)) {
            return true;
        }
        return this.onTouchEvent(ev);
    }

    public boolean dispatchTrackballEvent(MotionEvent ev) {
        if (this.mWindow.superDispatchTrackballEvent(ev)) {
            return true;
        }
        return this.onTrackballEvent(ev);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName((CharSequence)this.getClass().getName());
        event.setPackageName((CharSequence)this.mContext.getPackageName());
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        boolean isFullScreen = params.width == -1 && params.height == -1;
        event.setFullScreen(isFullScreen);
        return false;
    }

    public View onCreatePanelView(int featureId) {
        return null;
    }

    public boolean onCreatePanelMenu(int featureId, Menu menu) {
        if (featureId == 0) {
            return this.onCreateOptionsMenu(menu);
        }
        return false;
    }

    public boolean onPreparePanel(int featureId, View view, Menu menu) {
        if (featureId == 0 && menu != null) {
            boolean goforit = this.onPrepareOptionsMenu(menu);
            return goforit && menu.hasVisibleItems();
        }
        return true;
    }

    public boolean onMenuOpened(int featureId, Menu menu) {
        return true;
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        return false;
    }

    public void onPanelClosed(int featureId, Menu menu) {
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    public void onOptionsMenuClosed(Menu menu) {
    }

    public void openOptionsMenu() {
        this.mWindow.openPanel(0, null);
    }

    public void closeOptionsMenu() {
        this.mWindow.closePanel(0);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    public void openContextMenu(View view) {
        view.showContextMenu();
    }

    public boolean onContextItemSelected(MenuItem item) {
        return false;
    }

    public void onContextMenuClosed(Menu menu) {
    }

    public boolean onSearchRequested() {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        ComponentName appName = this.getAssociatedActivity();
        if (appName != null && searchManager.getSearchableInfo(appName) != null) {
            searchManager.startSearch(null, false, appName, null, false);
            this.dismiss();
            return true;
        }
        return false;
    }

    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return null;
    }

    private ComponentName getAssociatedActivity() {
        Activity activity = this.mOwnerActivity;
        Context context = this.getContext();
        while (activity == null && context != null) {
            if (context instanceof Activity) {
                activity = (Activity)context;
                continue;
            }
            context = context instanceof ContextWrapper ? ((ContextWrapper)context).getBaseContext() : null;
        }
        return activity == null ? null : activity.getComponentName();
    }

    public void takeKeyEvents(boolean get) {
        this.mWindow.takeKeyEvents(get);
    }

    public final boolean requestWindowFeature(int featureId) {
        return this.getWindow().requestFeature(featureId);
    }

    public final void setFeatureDrawableResource(int featureId, int resId) {
        this.getWindow().setFeatureDrawableResource(featureId, resId);
    }

    public final void setFeatureDrawableUri(int featureId, Uri uri) {
        this.getWindow().setFeatureDrawableUri(featureId, uri);
    }

    public final void setFeatureDrawable(int featureId, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(featureId, drawable2);
    }

    public final void setFeatureDrawableAlpha(int featureId, int alpha) {
        this.getWindow().setFeatureDrawableAlpha(featureId, alpha);
    }

    public LayoutInflater getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    public void setCancelable(boolean flag) {
        this.mCancelable = flag;
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        if (cancel && !this.mCancelable) {
            this.mCancelable = true;
        }
    }

    public void cancel() {
        if (!this.mCanceled && this.mCancelMessage != null) {
            this.mCanceled = true;
            Message.obtain((Message)this.mCancelMessage).sendToTarget();
        }
        this.dismiss();
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener listener) {
        if (this.mCancelAndDismissTaken != null) {
            throw new IllegalStateException("OnCancelListener is already taken by " + this.mCancelAndDismissTaken + " and can not be replaced.");
        }
        this.mCancelMessage = listener != null ? this.mListenersHandler.obtainMessage(68, (Object)listener) : null;
    }

    public void setCancelMessage(Message msg) {
        this.mCancelMessage = msg;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener) {
        if (this.mCancelAndDismissTaken != null) {
            throw new IllegalStateException("OnDismissListener is already taken by " + this.mCancelAndDismissTaken + " and can not be replaced.");
        }
        this.mDismissMessage = listener != null ? this.mListenersHandler.obtainMessage(67, (Object)listener) : null;
    }

    public void setOnShowListener(DialogInterface.OnShowListener listener) {
        this.mShowMessage = listener != null ? this.mListenersHandler.obtainMessage(69, (Object)listener) : null;
    }

    public void setDismissMessage(Message msg) {
        this.mDismissMessage = msg;
    }

    public boolean takeCancelAndDismissListeners(String msg, DialogInterface.OnCancelListener cancel, DialogInterface.OnDismissListener dismiss) {
        if (this.mCancelAndDismissTaken != null) {
            this.mCancelAndDismissTaken = null;
        } else if (this.mCancelMessage != null || this.mDismissMessage != null) {
            return false;
        }
        this.setOnCancelListener(cancel);
        this.setOnDismissListener(dismiss);
        this.mCancelAndDismissTaken = msg;
        return true;
    }

    public final void setVolumeControlStream(int streamType) {
        this.getWindow().setVolumeControlStream(streamType);
    }

    public final int getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.mOnKeyListener = onKeyListener;
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public void onActionModeStarted(ActionMode mode) {
    }

    public void onActionModeFinished(ActionMode mode) {
    }

    private static final class ListenersHandler
    extends Handler {
        private WeakReference<DialogInterface> mDialog;

        public ListenersHandler(Dialog dialog) {
            this.mDialog = new WeakReference<Dialog>(dialog);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 67: {
                    ((DialogInterface.OnDismissListener)msg.obj).onDismiss((DialogInterface)this.mDialog.get());
                    break;
                }
                case 68: {
                    ((DialogInterface.OnCancelListener)msg.obj).onCancel((DialogInterface)this.mDialog.get());
                    break;
                }
                case 69: {
                    ((DialogInterface.OnShowListener)msg.obj).onShow((DialogInterface)this.mDialog.get());
                }
            }
        }
    }
}

