/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.cross;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class CrossGroup
implements IModel {
    private static final String APP_KEY = "appkey";
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private Gson gson = new Gson();
    private String appKey;
    private String[] add_users;
    private String[] remove_users;

    private CrossGroup(String appKey, String[] add_users, String[] remove_users) {
        this.appKey = appKey;
        this.add_users = add_users;
        this.remove_users = remove_users;
    }

    public CrossGroup newBuilder() {
        return new Builder().build();
    }

    @Override
    public JsonElement toJSON() {
        JsonArray array;
        JsonObject json = new JsonObject();
        if (null != this.appKey) {
            json.addProperty(APP_KEY, this.appKey);
        }
        if (null != this.add_users) {
            array = new JsonArray();
            for (String user : this.add_users) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            json.add(ADD, (JsonElement)array);
        }
        if (null != this.remove_users) {
            array = new JsonArray();
            for (String user : this.remove_users) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            json.add(REMOVE, (JsonElement)array);
        }
        return json;
    }

    public String toString() {
        return this.gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String appKey;
        private String[] add_users;
        private String[] remove_users;

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setAddUsers(String ... users) {
            this.add_users = users;
            return this;
        }

        public Builder setRemoveUsers(String ... users) {
            this.remove_users = users;
            return this;
        }

        public CrossGroup build() {
            Preconditions.checkArgument((null != this.appKey ? 1 : 0) != 0, (Object)"AppKey must not be null");
            if (null == this.add_users && null == this.remove_users) {
                throw new IllegalArgumentException("At least one of add array or remove array should not be null");
            }
            return new CrossGroup(this.appKey, this.add_users, this.remove_users);
        }
    }
}

