/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.cross;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class CrossFriendPayload
implements IModel {
    private static final String APP_KEY = "appkey";
    private static final String USERS = "users";
    private Gson gson = new Gson();
    private String appKey;
    private String[] users;

    public CrossFriendPayload(String appKey, String[] users) {
        this.appKey = appKey;
        this.users = users;
    }

    public CrossFriendPayload newBuilder() {
        return new Builder().build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject jsonObject = new JsonObject();
        if (null != this.appKey) {
            jsonObject.addProperty(APP_KEY, this.appKey);
        }
        if (null != this.users) {
            JsonArray array = new JsonArray();
            for (String user : this.users) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            jsonObject.add(USERS, (JsonElement)array);
        }
        return jsonObject;
    }

    public String toString() {
        return this.gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String appKey;
        private String[] users;

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setUsers(String ... users) {
            this.users = users;
            return this;
        }

        public CrossFriendPayload build() {
            Preconditions.checkArgument((null != this.appKey ? 1 : 0) != 0, (Object)"AppKey should not be null!");
            Preconditions.checkArgument((null != this.users ? 1 : 0) != 0, (Object)"Users should not be null");
            return new CrossFriendPayload(this.appKey, this.users);
        }
    }
}

