/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.date.DateUtil;
import cn.hutool.poi.excel.CellEditor;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.cell.FormulaCellValue;
import cn.hutool.poi.excel.editors.TrimEditor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;

public class CellUtil {
    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        return CellUtil.getCellValue(cell, cell.getCellTypeEnum(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        if (null == cell) {
            return null;
        }
        return CellUtil.getCellValue(cell, cell.getCellTypeEnum(), cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        if (null == cell) {
            return null;
        }
        if (null == cellType) {
            cellType = cell.getCellTypeEnum();
        }
        switch (cellType) {
            case NUMERIC: {
                value = CellUtil.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = CellUtil.getCellValue(cell, cell.getCachedFormulaResultTypeEnum(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                value = null == error ? "" : error.getString();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet) {
        if (null != styleSet.cellStyle) {
            cell.setCellStyle(styleSet.cellStyle);
        }
        if (null == value) {
            cell.setCellValue("");
        } else if (value instanceof FormulaCellValue) {
            cell.setCellFormula(((FormulaCellValue)value).getValue());
        } else if (value instanceof Date) {
            if (null != styleSet && null != styleSet.cellStyleForDate) {
                cell.setCellStyle(styleSet.cellStyleForDate);
            }
            cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            if ((value instanceof Double || value instanceof Float) && null != styleSet && null != styleSet.cellStyleForNumber) {
                cell.setCellStyle(styleSet.cellStyleForNumber);
            }
            cell.setCellValue(((Number)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (row < ca.getFirstRow() || row > ca.getLastRow() || column < ca.getFirstColumn() || column > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTopEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRightEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottomEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeftEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
        return sheet.addMergedRegion(cellRangeAddress);
    }

    private static Object getNumericValue(Cell cell) {
        long longPart;
        String format;
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null == style) {
            return value;
        }
        short formatIndex = style.getDataFormat();
        if (CellUtil.isDateType(formatIndex, format = style.getDataFormatString())) {
            return DateUtil.date(cell.getDateCellValue());
        }
        if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
            return longPart;
        }
        return value;
    }

    private static boolean isDateType(int formatIndex, String format) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return org.apache.poi.ss.usermodel.DateUtil.isADateFormat((int)formatIndex, (String)format);
    }
}

